"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLegacyAlertTypes = createLegacyAlertTypes;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _lazy_expression = require("./lazy_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/legacy_alert/legacy_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_VALIDATE = () => ({
  errors: {}
});
function createLegacyAlertTypes(config) {
  return _constants.LEGACY_RULES.map(legacyAlert => {
    var _LEGACY_RULE_DETAILS$;
    const validate = (_LEGACY_RULE_DETAILS$ = _constants.LEGACY_RULE_DETAILS[legacyAlert].validate) !== null && _LEGACY_RULE_DETAILS$ !== void 0 ? _LEGACY_RULE_DETAILS$ : DEFAULT_VALIDATE;
    return {
      id: legacyAlert,
      description: _constants.LEGACY_RULE_DETAILS[legacyAlert].description,
      iconClass: 'bell',
      documentationUrl(docLinks) {
        return `${docLinks.links.monitoring.alertsKibanaClusterAlerts}`;
      },
      ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
        defaults: _constants.LEGACY_RULE_DETAILS[legacyAlert].defaults,
        expressionConfig: _constants.LEGACY_RULE_DETAILS[legacyAlert].expressionConfig,
        config: config,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 9
        }
      })),
      defaultActionMessage: '{{context.internalFullMessage}}',
      validate,
      requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT
    };
  });
}