"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ANOMALY = exports.AnomalyLayerWizardFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _locator = require("../../common/constants/locator");
var _util = require("./util");
var _create_anomaly_source_editor = require("./create_anomaly_source_editor");
var _anomaly_source = require("./anomaly_source");
var _http_service = require("../application/services/http_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/maps/anomaly_layer_wizard_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ML_ANOMALY = exports.ML_ANOMALY = 'ML_ANOMALIES';
const AnomalySourceEditorWithTheme = ({
  mlJobsService,
  jobsManagementPath,
  canCreateJobs,
  previewLayers
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleSourceConfigChange = sourceConfig => {
    if (!sourceConfig) {
      previewLayers([]);
      return;
    }
    const anomalyLayerDescriptor = {
      id: (0, _eui.htmlIdGenerator)()(),
      type: _common.LAYER_TYPE.GEOJSON_VECTOR,
      sourceDescriptor: _anomaly_source.AnomalySource.createDescriptor({
        jobId: sourceConfig.jobId,
        typicalActual: sourceConfig.typicalActual
      }),
      style: (0, _util.getActualStyle)(euiTheme)
    };
    previewLayers([anomalyLayerDescriptor]);
  };
  return /*#__PURE__*/_react.default.createElement(_create_anomaly_source_editor.CreateAnomalySourceEditor, {
    onSourceConfigChange: handleSourceConfigChange,
    mlJobsService: mlJobsService,
    jobsManagementPath: jobsManagementPath,
    canCreateJobs: canCreateJobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
class AnomalyLayerWizardFactory {
  constructor(getStartServices, canGetJobs, canCreateJobs) {
    (0, _defineProperty2.default)(this, "type", ML_ANOMALY);
    this.getStartServices = getStartServices;
    this.canGetJobs = canGetJobs;
    this.canCreateJobs = canCreateJobs;
    this.canGetJobs = canGetJobs;
    this.canCreateJobs = canCreateJobs;
  }
  async getServices() {
    const [coreStart, pluginStart] = await this.getStartServices();
    const {
      jobsApiProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service/jobs')));
    const httpService = new _http_service.HttpService(coreStart.http);
    const mlJobsService = jobsApiProvider(httpService);
    const mlLocator = pluginStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
    return {
      mlJobsService,
      mlLocator
    };
  }
  async create() {
    const {
      mlJobsService,
      mlLocator
    } = await this.getServices();
    let jobsManagementPath;
    if (mlLocator) {
      jobsManagementPath = await mlLocator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE
      });
    } else {
      // eslint-disable-next-line no-console
      console.error('Unable to get job management path.');
    }
    const {
      anomalyLayerWizard
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_layer_wizard')));
    anomalyLayerWizard.getIsDisabled = () => !this.canGetJobs;
    anomalyLayerWizard.renderWizard = ({
      previewLayers
    }) => {
      return /*#__PURE__*/_react.default.createElement(AnomalySourceEditorWithTheme, {
        mlJobsService: mlJobsService,
        jobsManagementPath: jobsManagementPath,
        canCreateJobs: this.canCreateJobs,
        previewLayers: previewLayers,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 9
        }
      });
    };
    return anomalyLayerWizard;
  }
}
exports.AnomalyLayerWizardFactory = AnomalyLayerWizardFactory;