"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnomalyChartsCasesAttachment = registerAnomalyChartsCasesAttachment;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cases = require("../../common/constants/cases");
var _app = require("../../common/constants/app");
var _get_anomaly_charts_services_dependencies = require("../embeddables/anomaly_charts/get_anomaly_charts_services_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/cases/register_anomaly_charts_attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function registerAnomalyChartsCasesAttachment(cases, coreStart, pluginStart) {
  cases.attachmentFramework.registerPersistableState({
    id: _cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_EXPLORER_CHARTS,
    icon: _app.PLUGIN_ICON,
    displayName: _i18n.i18n.translate('xpack.ml.cases.anomalyCharts.displayName', {
      defaultMessage: 'Anomaly charts'
    }),
    getAttachmentViewObject: () => ({
      event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.anomalyCharts.embeddableAddedEvent",
        defaultMessage: "added anomaly chart",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 9
        }
      }),
      timelineAvatar: _app.PLUGIN_ICON,
      children: /*#__PURE__*/_react.default.lazy(async () => {
        const {
          initializeAnomalyChartsAttachment
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_attachments')));
        const services = await (0, _get_anomaly_charts_services_dependencies.getAnomalyChartsServiceDependencies)(coreStart, pluginStart);
        return {
          default: initializeAnomalyChartsAttachment(pluginStart.fieldFormats, services)
        };
      })
    })
  });
}