"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultNotificationsListState = exports.NotificationsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/field-formats-plugin/common");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _entity_filter = require("./entity_filter");
var _ml_notifications_context = require("../../contexts/ml/ml_notifications_context");
var _notifications = require("../../../../common/constants/notifications");
var _saved_objects_warning = require("../../components/saved_objects_warning");
var _toast_notification_service = require("../../services/toast_notification_service");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _use_refresh = require("../../routing/use_refresh");
var _use_table_settings = require("../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _locator = require("../../../../common/constants/locator");
var _kibana = require("../../contexts/kibana");
var _ml = require("../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/notifications/components/notifications_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const levelBadgeMap = {
  [_notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.ERROR]: 'danger',
  [_notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.WARNING]: 'warning',
  [_notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.INFO]: 'default'
};
const getDefaultNotificationsListState = () => ({
  pageIndex: 0,
  pageSize: 25,
  sortField: 'timestamp',
  sortDirection: 'desc'
});
exports.getDefaultNotificationsListState = getDefaultNotificationsListState;
const NotificationsList = () => {
  const {
    services: {
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    lastCheckedAt,
    setLastCheckedAt,
    notificationsCounts,
    latestRequestedAt
  } = (0, _ml_notifications_context.useMlNotifications)();
  const timeFilter = (0, _mlDatePicker.useTimefilter)();
  const timeRange = (0, _mlDatePicker.useTimeRangeUpdates)();
  (0, _useMount.default)(function setTimeRangeOnMount() {
    if (latestRequestedAt !== null) {
      timeFilter.setTime({
        from: (0, _moment.default)(latestRequestedAt).toISOString(),
        to: 'now'
      });
    }
  });
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [items, setItems] = (0, _react.useState)([]);
  const [totalCount, setTotalCount] = (0, _react.useState)(0);
  const [queryError, setQueryError] = (0, _react.useState)('');
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const [pageState, updatePageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.NOTIFICATIONS, getDefaultNotificationsListState());
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_settings.useTableSettings)(totalCount, pageState, updatePageState);
  const refresh = (0, _use_refresh.useRefresh)();
  const searchQueryText = pageState.queryText;
  const queryInstance = (0, _react.useMemo)(() => {
    try {
      setQueryError('');
      return _eui.EuiSearchBar.Query.parse(searchQueryText !== null && searchQueryText !== void 0 ? searchQueryText : '');
    } catch (error) {
      setQueryError(error.message);
    }
  }, [searchQueryText, setQueryError]);
  const fetchNotifications = (0, _react.useCallback)(async () => {
    if (!queryInstance) return;
    const queryString = _eui.EuiSearchBar.Query.toESQueryString(queryInstance);
    try {
      setIsLoading(true);
      const response = await mlApi.notifications.findMessages({
        sortField: sorting.sort.field,
        sortDirection: sorting.sort.direction,
        earliest: timeRange.from,
        latest: timeRange.to,
        queryString
      });
      setItems(response.results);
      setTotalCount(response.total);
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.notifications.fetchFailedError', {
        defaultMessage: 'Error loading list of notifications'
      }));
    }
    setIsLoading(false);
  }, [sorting, queryInstance, mlApi.notifications, displayErrorToast, timeRange]);
  (0, _react.useEffect)(function updateLastCheckedAt() {
    // Resolve the latest timestamp on the current page
    const pageItemIndex = pagination.pageIndex * pagination.pageSize;
    const currentPageItems = items.slice(pageItemIndex, pageItemIndex + pagination.pageSize);
    const latestTimestamp = Math.max(...currentPageItems.map(v => v.timestamp), lastCheckedAt !== null && lastCheckedAt !== void 0 ? lastCheckedAt : 0);
    if (latestTimestamp !== lastCheckedAt && latestTimestamp !== 0) {
      setLastCheckedAt(latestTimestamp);
    }
  }, [lastCheckedAt, setLastCheckedAt, items, pagination.pageIndex, pagination.pageSize]);
  (0, _useDebounce.default)(function refetchNotification() {
    fetchNotifications();
  }, 500, [sorting, queryInstance, refresh]);
  const columns = (0, _react.useMemo)(() => {
    return [{
      id: 'timestamp',
      field: 'timestamp',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notifications.timeLabel",
        defaultMessage: "Time",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }),
      sortable: true,
      truncateText: false,
      'data-test-subj': 'mlNotificationTime',
      width: '220px',
      render: v => dateFormatter(v)
    }, {
      field: 'level',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notifications.levelLabel",
        defaultMessage: "Level",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 15
        }
      }),
      sortable: true,
      truncateText: false,
      'data-test-subj': 'mlNotificationLevel',
      render: value => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: levelBadgeMap[value],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 18
          }
        }, value);
      },
      width: '11%'
    }, {
      field: 'job_type',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notifications.typeLabel",
        defaultMessage: "Type",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 15
        }
      }),
      sortable: true,
      truncateText: false,
      'data-test-subj': 'mlNotificationType',
      render: value => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: 'hollow',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 18
          }
        }, value);
      },
      width: '14%'
    }, {
      field: 'job_id',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notifications.entityLabel",
        defaultMessage: "Entity ID",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 11
        }
      }),
      sortable: true,
      truncateText: true,
      'data-test-subj': 'mlNotificationEntity',
      width: '22%'
    }, {
      field: 'message',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notifications.messageLabel",
        defaultMessage: "Message",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 11
        }
      }),
      sortable: false,
      truncateText: {
        lines: 8
      },
      'data-test-subj': 'mlNotificationMessage',
      width: '25%'
    }];
  }, [dateFormatter]);
  const filters = (0, _react.useMemo)(() => {
    const jobTypeOptions = [];
    if (isADEnabled === true) {
      jobTypeOptions.push({
        value: 'anomaly_detector',
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.type.anomalyDetector', {
          defaultMessage: 'Anomaly Detection'
        })
      });
    }
    if (isDFAEnabled === true) {
      jobTypeOptions.push({
        value: 'data_frame_analytics',
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.type.dfa', {
          defaultMessage: 'Data Frame Analytics'
        })
      });
    }
    if (isNLPEnabled === true || isDFAEnabled === true) {
      jobTypeOptions.push({
        value: 'inference',
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.type.inference', {
          defaultMessage: 'Inference'
        })
      });
    }
    jobTypeOptions.push({
      value: 'system',
      name: _i18n.i18n.translate('xpack.ml.notifications.filters.type.system', {
        defaultMessage: 'System'
      })
    });
    return [{
      type: 'field_value_selection',
      field: 'level',
      name: _i18n.i18n.translate('xpack.ml.notifications.filters.level.name', {
        defaultMessage: 'Level'
      }),
      multiSelect: 'or',
      options: [{
        value: _notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.ERROR,
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.level.error', {
          defaultMessage: 'Error'
        }),
        field: 'level'
      }, {
        value: _notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.WARNING,
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.level.warning', {
          defaultMessage: 'Warning'
        }),
        field: 'level'
      }, {
        value: _notifications.ML_NOTIFICATIONS_MESSAGE_LEVEL.INFO,
        name: _i18n.i18n.translate('xpack.ml.notifications.filters.level.info', {
          defaultMessage: 'Info'
        }),
        field: 'level'
      }]
    }, {
      type: 'field_value_selection',
      field: 'job_type',
      name: _i18n.i18n.translate('xpack.ml.notifications.filters.level.type', {
        defaultMessage: 'Type'
      }),
      multiSelect: 'or',
      options: jobTypeOptions
    }, {
      type: 'custom_component',
      component: _entity_filter.EntityFilter
    }];
  }, [isADEnabled, isDFAEnabled, isNLPEnabled]);
  const newNotificationsCount = Object.values(notificationsCounts).reduce((a, b) => a + b);
  const itemsPerPage = (0, _react.useMemo)(() => {
    const fromIndex = pagination.pageIndex * pagination.pageSize;
    const toIndex = fromIndex + pagination.pageSize;
    return items.slice(fromIndex, toIndex);
  }, [items, pagination]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: fetchNotifications,
    forceRefresh: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }), newNotificationsCount && !isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.notifications.newNotificationsMessage",
      defaultMessage: "There {newNotificationsCount, plural, one {is # notification} other {are # notifications}} since {sinceDate}. Refresh the page to view updates.",
      values: {
        sinceDate: dateFormatter(latestRequestedAt),
        newNotificationsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 15
      }
    }),
    iconType: "bell",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: queryInstance,
    box: {
      placeholder: _i18n.i18n.translate('xpack.ml.notifications.searchPlaceholder', {
        defaultMessage: 'Search for notifications. Example: job_type:anomaly_detector -level:(info) Datafeed'
      }),
      incremental: false,
      schema: {
        strict: true,
        fields: {
          level: {
            type: 'string',
            name: 'level',
            searchable: false,
            aggregatable: true
          },
          job_type: {
            type: 'string',
            name: 'job_type',
            searchable: false,
            aggregatable: true
          },
          job_id: {
            type: 'string',
            name: 'job_id',
            searchable: false,
            aggregatable: true
          },
          message: {
            type: 'string',
            name: 'message',
            searchable: true,
            aggregatable: false
          }
        }
      },
      'data-test-subj': 'mlNotificationsSearchBarInput'
    },
    filters: filters,
    onChange: e => {
      updatePageState({
        queryText: e.queryText
      });
    },
    "data-test-subj": 'mlNotificationsSearchBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }), queryError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: 's',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.notifications.invalidQueryError",
      defaultMessage: "Query is not valid: ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 13
    }
  }, queryError)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    rowHeader: "timestamp",
    items: itemsPerPage,
    itemId: 'id',
    loading: isLoading,
    rowProps: item => ({
      'data-test-subj': `mlNotificationsTableRow row-${item.id}`
    }),
    pagination: pagination,
    onChange: onTableChange,
    sorting: sorting,
    "data-test-subj": isLoading ? 'mlNotificationsTable loading' : 'mlNotificationsTable loaded',
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.notifications.noItemsFoundMessage",
      defaultMessage: "No notifications found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 417,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 7
    }
  }));
};
exports.NotificationsList = NotificationsList;