"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceApi = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/inference_api_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InferenceApi = ({
  inferenceApis
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inferenceApis.map((inferenceApi, i) => {
    const initialIsOpen = i <= 2;
    const modelId = inferenceApi.inference_id;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: modelId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: modelId,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 19
        }
      }, modelId)),
      paddingSize: "l",
      initialIsOpen: initialIsOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineDefinition_${modelId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceApiDefinitionTitle",
      defaultMessage: "Definition",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      overflowHeight: 300,
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 21
      }
    }, JSON.stringify(inferenceApi, null, 2)))))));
  }));
};
exports.InferenceApi = InferenceApi;