"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/management/jobs_list/components/jobs_list_page/docs_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocsLink = ({
  currentTabId
}) => {
  const {
    services: {
      docLinks: {
        links: {
          ml
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  let href = ml.anomalyDetectionJobs;
  let linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.anomalyDetectionDocsLabel', {
    defaultMessage: 'Anomaly detection jobs docs'
  });
  if (currentTabId === 'data-frame-analytics') {
    href = ml.dataFrameAnalytics;
    linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.analyticsDocsLabel', {
      defaultMessage: 'Analytics jobs docs'
    });
  } else if (currentTabId === 'trained-model') {
    href = ml.trainedModels;
    linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.trainedModelsDocsLabel', {
      defaultMessage: 'Trained models docs'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: href,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "mlDocumentationLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, linkLabel);
};
exports.DocsLink = DocsLink;