"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventRateChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../contexts/kibana");
var _axes = require("../common/axes");
var _settings = require("../common/settings");
var _loading_wrapper = require("../loading_wrapper");
var _anomalies = require("../common/anomalies");
var _overlay_range = require("./overlay_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/charts/event_rate_chart/event_rate_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EventRateChart = ({
  eventRateChartData,
  anomalyData,
  height,
  width,
  showAxis,
  loading = false,
  fadeChart,
  overlayRanges,
  onBrushEnd
}) => {
  const {
    services: {
      charts: {
        theme: {
          useChartsBaseTheme
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const baseTheme = useChartsBaseTheme();
  const {
    EVENT_RATE_COLOR_WITH_ANOMALIES,
    EVENT_RATE_COLOR
  } = (0, _settings.useChartColors)();
  const barColor = fadeChart ? EVENT_RATE_COLOR_WITH_ANOMALIES : EVENT_RATE_COLOR;
  const theme = {
    scales: {
      histogramPadding: 0.2
    }
  };
  const cssOverride = (0, _react2.css)({
    // fix for the annotation label being hidden inside the bounds of the chart container
    '.echContainer': {
      overflow: 'visible'
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `mlEventRateChart ${eventRateChartData.length ? 'withData' : 'empty'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    height: height,
    hasData: eventRateChartData.length > 0,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    css: overlayRanges !== undefined ? cssOverride : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, showAxis === true && /*#__PURE__*/_react.default.createElement(_axes.Axes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: onBrushEnd,
    theme: theme,
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }), overlayRanges && overlayRanges.map((range, i) => /*#__PURE__*/_react.default.createElement(_overlay_range.OverlayRange, {
    key: i,
    overlayKey: i,
    start: range.start,
    end: range.end,
    color: range.color,
    showMarker: range.showMarker,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_anomalies.Anomalies, {
    anomalyData: anomalyData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: "event_rate"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: eventRateChartData,
    color: barColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))));
};
exports.EventRateChart = EventRateChart;