"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableSectionAnalytics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _get_analytics = require("../../../analytics_management/services/analytics_service/get_analytics");
var _common = require("../../../analytics_management/components/analytics_list/common");
var _expanded_row = require("../../../analytics_management/components/analytics_list/expanded_row");
var _kibana = require("../../../../../contexts/kibana");
var _expandable_section = require("./expandable_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/expandable_section/expandable_section_analytics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAnalyticsSectionHeaderItems = expandedRowItem => {
  if (expandedRowItem === undefined) {
    return _expandable_section.HEADER_ITEMS_LOADING;
  }
  const sourceIndex = Array.isArray(expandedRowItem.config.source.index) ? expandedRowItem.config.source.index.join() : expandedRowItem.config.source.index;
  return [{
    id: 'analysisTypeLabel',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.analysisTypeLabel",
      defaultMessage: "Type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }),
    value: expandedRowItem.job_type
  }, {
    id: 'analysisSourceIndexLabel',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.analysisSourceIndexLabel",
      defaultMessage: "Source index",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    value: sourceIndex
  }, {
    id: 'analysisDestinationIndexLabel',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.analysisDestinationIndexLabel",
      defaultMessage: "Destination index",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }),
    value: expandedRowItem.config.dest.index
  }];
};
const ExpandableSectionAnalytics = ({
  jobId
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const [expandedRowItem, setExpandedRowItem] = (0, _react.useState)();
  const fetchStats = async () => {
    const analyticsConfigs = await mlApi.dataFrameAnalytics.getDataFrameAnalytics(jobId);
    const analyticsStats = await mlApi.dataFrameAnalytics.getDataFrameAnalyticsStats(jobId);
    const config = analyticsConfigs.data_frame_analytics[0];
    const stats = (0, _get_analytics.isGetDataFrameAnalyticsStatsResponseOk)(analyticsStats) ? analyticsStats.data_frame_analytics[0] : undefined;
    if (stats === undefined) {
      return;
    }
    const newExpandedRowItem = {
      checkpointing: {},
      config,
      id: config.id,
      job_type: (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(config.analysis),
      mode: _common.DATA_FRAME_MODE.BATCH,
      state: stats.state,
      stats
    };
    setExpandedRowItem(newExpandedRowItem);
  };
  (0, _react.useEffect)(() => {
    fetchStats();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  const analyticsSectionHeaderItems = getAnalyticsSectionHeaderItems(expandedRowItem);
  const analyticsSectionContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expandedRowItem === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  })), expandedRowItem !== undefined && /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
    item: expandedRowItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 41
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    dataTestId: "analysis",
    content: analyticsSectionContent,
    headerItems: analyticsSectionHeaderItems,
    urlStateKey: 'analysis',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.analysisSectionTitle",
      defaultMessage: "Analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
exports.ExpandableSectionAnalytics = ExpandableSectionAnalytics;