"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelectorControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _kibana = require("../application/contexts/kibana");
var _alerts = require("../../common/constants/alerts");
var _loading_indicator = require("../application/components/loading_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/job_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobSelectorControl = ({
  jobsAndGroupIds,
  onChange,
  adJobsApiService,
  errors,
  multiSelect = false,
  label,
  allowSelectAll = false,
  createJobUrl,
  options: defaultOptions,
  shouldUseDropdownJobCreate = false
}) => {
  const {
    services: {
      notifications: {
        toasts
      },
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana.useMlKibana)();
  const isMounted = (0, _useMountedState.default)();
  const [options, setOptions] = (0, _react.useState)([]);
  const [areJobsLoading, setAreJobsLoading] = (0, _react.useState)(false);
  const jobIds = (0, _react.useMemo)(() => new Set(), []);
  const groupIds = (0, _react.useMemo)(() => new Set(), []);
  const selectedOptions = (0, _react.useMemo)(() => (jobsAndGroupIds !== null && jobsAndGroupIds !== void 0 ? jobsAndGroupIds : []).map(v => ({
    label: v
  })), [jobsAndGroupIds]);
  const fetchOptions = (0, _react.useCallback)(async () => {
    setAreJobsLoading(true);
    try {
      const {
        jobIds: jobIdOptions,
        groupIds: groupIdOptions
      } = await adJobsApiService.getAllJobAndGroupIds();
      jobIdOptions.forEach(v => {
        jobIds.add(v);
      });
      groupIdOptions.forEach(v => {
        groupIds.add(v);
      });
      if (!isMounted()) return;
      setOptions([...(allowSelectAll ? [{
        label: _i18n.i18n.translate('xpack.ml.jobSelector.selectAllGroupLabel', {
          defaultMessage: 'Select all'
        }),
        options: [{
          label: _i18n.i18n.translate('xpack.ml.jobSelector.selectAllOptionLabel', {
            defaultMessage: '*'
          }),
          value: _alerts.ALL_JOBS_SELECTION
        }]
      }] : []), {
        label: _i18n.i18n.translate('xpack.ml.jobSelector.jobOptionsLabel', {
          defaultMessage: 'Jobs'
        }),
        options: [...(createJobUrl ? [{
          label: _i18n.i18n.translate('xpack.ml.jobSelector.createNewLabel', {
            defaultMessage: '--- Create new ---'
          }),
          value: 'createNew'
        }] : []), ...jobIdOptions.map(v => ({
          label: v
        }))]
      }, ...(multiSelect ? [{
        label: _i18n.i18n.translate('xpack.ml.jobSelector.groupOptionsLabel', {
          defaultMessage: 'Groups'
        }),
        options: groupIdOptions.map(v => ({
          label: v
        }))
      }] : [])]);
    } catch (e) {
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.ml.jobSelector.fetchJobErrorTitle', {
          defaultMessage: 'Failed to load anomaly detection jobs'
        })
      });
    }
    setAreJobsLoading(false);
  }, [adJobsApiService, allowSelectAll, createJobUrl, groupIds, isMounted, jobIds, multiSelect, toasts]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const onSelectionChange = (0, _react.useCallback)(async selectionUpdate => {
    if (selectionUpdate.some(selectedOption => selectedOption.value === _alerts.ALL_JOBS_SELECTION)) {
      onChange({
        jobIds: [_alerts.ALL_JOBS_SELECTION]
      });
      return;
    }
    if (!!createJobUrl && selectionUpdate.some(selectedOption => selectedOption.value === 'createNew')) {
      // Redirect to the job wizard page
      await navigateToUrl(createJobUrl);
      return;
    }
    const selectedJobIds = [];
    const selectedGroupIds = [];
    selectionUpdate.forEach(({
      label: selectedLabel
    }) => {
      if (jobIds.has(selectedLabel)) {
        selectedJobIds.push(selectedLabel);
      } else if (groupIds.has(selectedLabel)) {
        selectedGroupIds.push(selectedLabel);
      } else if (defaultOptions !== null && defaultOptions !== void 0 && defaultOptions.some(v => {
        var _v$options;
        return (_v$options = v.options) === null || _v$options === void 0 ? void 0 : _v$options.some(o => o.label === selectedLabel);
      })) {
        selectedJobIds.push(selectedLabel);
      }
    });
    onChange({
      ...(selectedJobIds.length > 0 ? {
        jobIds: selectedJobIds
      } : {}),
      ...(selectedGroupIds.length > 0 ? {
        groupIds: selectedGroupIds
      } : {})
    });
  }, [jobIds, groupIds, defaultOptions, createJobUrl]);
  (0, _react.useEffect)(() => {
    if (defaultOptions) return;
    fetchOptions();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [createJobUrl]);
  if (areJobsLoading === true) return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 39
    }
  });
  return jobIds.size || shouldUseDropdownJobCreate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "mlAnomalyJobSelectionControls",
    fullWidth: true,
    label: label !== null && label !== void 0 ? label : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.formControlLabel",
      defaultMessage: "Select job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 11
      }
    }),
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: !multiSelect,
    selectedOptions: selectedOptions,
    options: defaultOptions !== null && defaultOptions !== void 0 ? defaultOptions : options,
    onChange: onSelectionChange,
    fullWidth: true,
    "data-test-subj": 'mlAnomalyAlertJobSelection',
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "mlAnomalyJobSelectionControls",
    titleSize: "xxs",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.embeddables.jobSelector.noJobsFoundTitle",
      defaultMessage: "No anomaly detection jobs found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: () => navigateToUrl(createJobUrl),
      disabled: createJobUrl === undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.embeddables.jobSelector.createJobButtonLabel",
      defaultMessage: "Create job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 5
    }
  });
};
exports.JobSelectorControl = JobSelectorControl;