"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetViewControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _set_view_form = require("./set_view_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/set_view_control/set_view_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SetViewControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", (lat, lon, zoom) => {
      this._closePopover();
      this.props.onSubmit({
        lat,
        lon,
        zoom
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "leftUp",
      panelPaddingSize: "s",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "none",
        className: "mapToolbarOverlay__button",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        className: "mapToolbarOverlay__buttonIcon-empty",
        size: "s",
        onClick: this._togglePopover,
        "data-test-subj": "toggleSetViewVisibilityButton",
        iconType: "crosshairs",
        color: "text",
        "aria-label": _i18n.i18n.translate('xpack.maps.setViewControl.goToButtonLabel', {
          defaultMessage: 'Go to'
        }),
        title: _i18n.i18n.translate('xpack.maps.setViewControl.goToButtonLabel', {
          defaultMessage: 'Go to'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      })),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_set_view_form.SetViewForm, {
      settings: this.props.settings,
      zoom: this.props.zoom,
      center: this.props.center,
      onSubmit: this._onSubmit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }));
  }
}
exports.SetViewControl = SetViewControl;