"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerSizeLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _get_ordinal_label = require("./get_ordinal_label");
var _marker_list = require("./marker_list");
var _map_marker = require("./map_marker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/size/marker_size_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FONT_SIZE = 10;
const HALF_FONT_SIZE = FONT_SIZE / 2;
const EMPTY_VALUE = '';
class MarkerSizeLegend extends _react.Component {
  static getDerivedStateFromProps(nextProps, prevState) {
    const nextFieldMeta = nextProps.style.getRangeFieldMeta();
    return !_lodash.default.isEqual(nextFieldMeta, prevState.fieldMeta) ? {
      maxLabelWidth: 0,
      fieldMeta: nextFieldMeta
    } : null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onRightAlignedWidthChange", width => {
      if (width > this.state.maxLabelWidth) {
        this.setState({
          maxLabelWidth: width
        });
      }
    });
    this.state = {
      label: EMPTY_VALUE,
      maxLabelWidth: 0,
      fieldMeta: this.props.style.getRangeFieldMeta()
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const field = this.props.style.getField();
    if (!field) {
      return;
    }
    const label = await field.getLabel();
    if (this._isMounted && this.state.label !== label) {
      this.setState({
        label
      });
    }
  }
  _formatValue(value) {
    return value === EMPTY_VALUE ? value : this.props.style.formatField(value);
  }
  _renderMarkers() {
    const fieldMeta = this.state.fieldMeta;
    const options = this.props.style.getOptions();
    if (!fieldMeta || !options) {
      return null;
    }
    const invert = options.invert === undefined ? false : options.invert;
    const circleStyle = {
      fillOpacity: 0,
      strokeWidth: 1
    };
    const svgHeight = options.maxSize * 2 + HALF_FONT_SIZE + circleStyle.strokeWidth * 2;
    const circleCenterX = options.maxSize + circleStyle.strokeWidth;
    const circleBottomY = svgHeight - circleStyle.strokeWidth;
    const makeMarker = (radius, formattedValue) => {
      const circleCenterY = circleBottomY - radius;
      const circleTopY = circleCenterY - radius;
      const textOffset = this.state.maxLabelWidth + HALF_FONT_SIZE;
      const rawTextY = circleTopY + HALF_FONT_SIZE;
      const textY = rawTextY > svgHeight ? svgHeight : rawTextY;
      return {
        svg: /*#__PURE__*/_react.default.createElement(_map_marker.MapMarker, {
          circleCenterX: circleCenterX,
          circleCenterY: circleCenterY,
          circleTopY: circleTopY,
          circleStyle: circleStyle,
          radius: radius,
          textOffset: textOffset,
          textY: textY,
          formattedValue: formattedValue,
          onWidthChange: this._onRightAlignedWidthChange,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 11
          }
        }),
        textY
      };
    };
    function getMarkerRadius(percentage) {
      const delta = options.maxSize - options.minSize;
      return percentage * delta + options.minSize;
    }
    function getValue(percentage) {
      // Markers interpolated by area instead of radius to be more consistent with how the human eye+brain perceive shapes
      // and their visual relevance
      // This function mirrors output of maplibre expression created from DynamicSizeProperty.getMbSizeExpression
      const scaledWidth = Math.pow(percentage * Math.sqrt(fieldMeta.delta), 2);
      const value = invert ? fieldMeta.max - scaledWidth : scaledWidth + fieldMeta.min;
      return fieldMeta.delta > 3 ? Math.round(value) : value;
    }
    const maxLabel = (0, _get_ordinal_label.getMaxLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMaxOutsideStdRange), this._formatValue(fieldMeta.max));
    const minLabel = (0, _get_ordinal_label.getMinLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMinOutsideStdRange), this._formatValue(fieldMeta.min));
    const markerList = new _marker_list.MarkerList(FONT_SIZE, makeMarker(options.maxSize, invert ? minLabel : maxLabel));
    if (fieldMeta.delta > 0) {
      markerList.push(makeMarker(options.minSize, invert ? maxLabel : minLabel));
      markerList.push(makeMarker(getMarkerRadius(0.25), this._formatValue(getValue(0.25))));
      markerList.push(makeMarker(getMarkerRadius(0.5), this._formatValue(getValue(0.5))));
      markerList.push(makeMarker(getMarkerRadius(0.75), this._formatValue(getValue(0.75))));
    }
    return /*#__PURE__*/_react.default.createElement("svg", {
      height: svgHeight,
      xmlns: "http://www.w3.org/2000/svg",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    }, markerList.getMarkers());
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      title: this.props.style.getDisplayStyleName(),
      content: this.state.label,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      tabIndex: 0,
      className: "eui-textTruncate",
      size: "xs",
      style: {
        maxWidth: '180px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 19
      }
    }, this.state.label)))))), this._renderMarkers());
  }
}
exports.MarkerSizeLegend = MarkerSizeLegend;