"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorStops = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _color_stops_utils = require("./color_stops_utils");
var _i18n = require("@kbn/i18n");
var _mb_validated_color_picker = require("./mb_validated_color_picker");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _map_color_stops = require("../map_color_stops.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/color_stops.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorStops = ({
  onChange,
  colorStops,
  isStopsInvalid,
  getStopError,
  renderStopInput,
  addNewRow,
  swatches
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(_map_color_stops.mapColorStopsStyles);
  function getStopInput(stop, index) {
    const onStopChange = newStopValue => {
      const newColorStops = _lodash.default.cloneDeep(colorStops);
      newColorStops[index].stop = newStopValue;
      onChange({
        colorStops: newColorStops,
        isInvalid: isStopsInvalid(newColorStops)
      });
    };
    return {
      stopError: getStopError(stop, index),
      stopInput: renderStopInput(stop, onStopChange, index)
    };
  }
  const rows = colorStops.map((colorStop, index) => {
    const onColorChange = color => {
      const newColorStops = _lodash.default.cloneDeep(colorStops);
      newColorStops[index].color = color;
      onChange({
        colorStops: newColorStops,
        isInvalid: isStopsInvalid(newColorStops)
      });
    };
    const {
      stopError,
      stopInput
    } = getStopInput(colorStop.stop, index);
    const color = colorStop.color;
    const colorError = (0, _color_stops_utils.isColorInvalid)(color) ? _i18n.i18n.translate('xpack.maps.styles.colorStops.hexWarningLabel', {
      defaultMessage: 'Color must provide a valid hex value'
    }) : undefined;
    const errors = [];
    if (stopError) {
      errors.push(stopError);
    }
    if (colorError) {
      errors.push(colorError);
    }
    const onAdd = () => {
      const newColorStops = addNewRow(colorStops, index);
      onChange({
        colorStops: newColorStops,
        isInvalid: isStopsInvalid(newColorStops)
      });
    };
    let deleteButton;
    if (colorStops.length > 1) {
      const onRemove = () => {
        const newColorStops = (0, _color_stops_utils.removeRow)(colorStops, index);
        onChange({
          colorStops: newColorStops,
          isInvalid: isStopsInvalid(newColorStops)
        });
      };
      deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "trash",
        color: "danger",
        "aria-label": _i18n.i18n.translate('xpack.maps.styles.colorStops.deleteButtonAriaLabel', {
          defaultMessage: 'Delete'
        }),
        title: _i18n.i18n.translate('xpack.maps.styles.colorStops.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        onClick: onRemove,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 9
        }
      });
    }
    const colorPickerButtons = /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    }, deleteButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      color: "primary",
      "aria-label": "Add",
      title: "Add",
      onClick: onAdd,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: index,
      css: styles.mapColorStops,
      isInvalid: errors.length !== 0,
      error: errors,
      display: "rowCompressed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: "mapStyleSettings__fixedBox",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, stopInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
      key: color,
      onChange: onColorChange,
      color: color,
      swatches: swatches,
      append: colorPickerButtons,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }))));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, rows, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }));
};
exports.ColorStops = ColorStops;