"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLayerTemplate = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _layer_select = require("./layer_select");
var _metric_select = require("./metric_select");
var _display_select = require("./display_select");
var _create_layer_descriptor = require("./create_layer_descriptor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/observability/observability_layer_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ObservabilityLayerTemplate extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      layer: null,
      metric: null,
      display: _display_select.DISPLAY.CHOROPLETH
    });
    (0, _defineProperty2.default)(this, "_onLayerChange", layer => {
      const newState = {
        layer,
        metric: this.state.metric
      };

      // Select metric when layer change invalidates selected metric.
      const metricOptions = (0, _metric_select.getMetricOptionsForLayer)(layer);
      const selectedMetricOption = metricOptions.find(option => {
        return option.value === this.state.metric;
      });
      if (!selectedMetricOption) {
        if (metricOptions.length) {
          // @ts-ignore
          newState.metric = metricOptions[0].value;
        } else {
          newState.metric = null;
        }
      }
      this.setState(newState, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onMetricChange", metric => {
      this.setState({
        metric
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onDisplayChange", display => {
      this.setState({
        display
      }, this._previewLayer);
    });
  }
  _previewLayer() {
    const layerDescriptor = (0, _create_layer_descriptor.createLayerDescriptor)({
      layer: this.state.layer,
      metric: this.state.metric,
      display: this.state.display
    });
    this.props.previewLayers(layerDescriptor ? [layerDescriptor] : []);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_layer_select.LayerSelect, {
      value: this.state.layer,
      onChange: this._onLayerChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
      layer: this.state.layer,
      value: this.state.metric,
      onChange: this._onMetricChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_display_select.DisplaySelect, {
      layer: this.state.layer,
      value: this.state.display,
      onChange: this._onDisplayChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }));
  }
}
exports.ObservabilityLayerTemplate = ObservabilityLayerTemplate;