"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newVectorLayerWizardConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _wizard = require("./wizard");
var _draw_layer_icon = require("../icons/draw_layer_icon");
var _kibana_services = require("../../../../kibana_services");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/new_vector_layer_wizard/config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ADD_VECTOR_DRAWING_LAYER = 'ADD_VECTOR_DRAWING_LAYER';
const newVectorLayerWizardConfig = exports.newVectorLayerWizardConfig = {
  id: _constants.WIZARD_ID.NEW_VECTOR,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.newVectorLayerWizard.description', {
    defaultMessage: 'Draw shapes on the map and index in Elasticsearch'
  }),
  disabledReason: _i18n.i18n.translate('xpack.maps.newVectorLayerWizard.disabledDesc', {
    defaultMessage: 'Unable to create index, you are missing the Kibana privilege "Data View Management".'
  }),
  getIsDisabled: async () => {
    const hasImportPermission = await (0, _kibana_services.getFileUpload)().hasImportPermission({
      checkCreateDataView: true,
      checkHasManagePipeline: false
    });
    return !hasImportPermission;
  },
  isBeta: true,
  icon: _draw_layer_icon.DrawLayerIcon,
  prerequisiteSteps: [{
    id: ADD_VECTOR_DRAWING_LAYER,
    label: _i18n.i18n.translate('xpack.maps.newVectorLayerWizard.indexNewLayer', {
      defaultMessage: 'Create index'
    })
  }],
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_wizard.NewVectorLayerEditor, (0, _extends2.default)({}, renderWizardArguments, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    }));
  },
  showFeatureEditTools: true,
  title: _i18n.i18n.translate('xpack.maps.newVectorLayerWizard.title', {
    defaultMessage: 'Create index'
  })
};