"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoJsonVectorLayer = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _vector_style = require("../../../styles/vector/vector_style");
var _layer = require("../../layer");
var _vector_layer = require("../vector_layer");
var _get_feature_collection_bounds = require("../../../util/get_feature_collection_bounds");
var _geojson_source_data = require("./geojson_source_data");
var _perform_inner_joins = require("./perform_inner_joins");
var _pluck_style_meta_from_features = require("./pluck_style_meta_from_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/vector_layer/geojson_vector_layer/geojson_vector_layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class GeoJsonVectorLayer extends _vector_layer.AbstractVectorLayer {
  static createDescriptor(options, mapColors) {
    const layerDescriptor = super.createDescriptor(options);
    layerDescriptor.type = _constants.LAYER_TYPE.GEOJSON_VECTOR;
    if (!options.style) {
      const styleProperties = _vector_style.VectorStyle.createDefaultStyleProperties(mapColors ? mapColors : []);
      layerDescriptor.style = _vector_style.VectorStyle.createDescriptor(styleProperties);
    }
    if (!options.joins) {
      layerDescriptor.joins = [];
    }
    return layerDescriptor;
  }
  isLayerLoading(zoom) {
    var _featureCollection$fe;
    if (!this.isVisible() || !this.showAtZoomLevel(zoom)) {
      return false;
    }
    const isSourceLoading = super.isLayerLoading(zoom);
    if (isSourceLoading) {
      return true;
    }

    // Do not check join loading status when there are no source features. Why?
    // syncMeta short circuits join loading when there are no source features
    // because there is no reason to fetch join results when there is nothing to join with
    const featureCollection = this._getSourceFeatureCollection();
    if (!featureCollection || (featureCollection === null || featureCollection === void 0 ? void 0 : (_featureCollection$fe = featureCollection.features) === null || _featureCollection$fe === void 0 ? void 0 : _featureCollection$fe.length) === 0) {
      return false;
    }
    return this._isLoadingJoins();
  }
  _isTiled() {
    // Uses untiled maplibre source 'geojson'
    return false;
  }
  async getBounds(getDataRequestContext) {
    const isStaticLayer = !this.getSource().isBoundsAware();
    return isStaticLayer || this.hasJoins() ? (0, _get_feature_collection_bounds.getFeatureCollectionBounds)(this._getSourceFeatureCollection(), this.hasJoins()) : super.getBounds(getDataRequestContext);
  }
  getLayerIcon(isTocIcon) {
    const featureCollection = this._getSourceFeatureCollection();
    if (!featureCollection || featureCollection.features.length === 0) {
      return _vector_layer.NO_RESULTS_ICON_AND_TOOLTIPCONTENT;
    }
    if (this.getJoins().length && !featureCollection.features.some(feature => {
      var _feature$properties;
      return (_feature$properties = feature.properties) === null || _feature$properties === void 0 ? void 0 : _feature$properties[_constants.FEATURE_VISIBLE_PROPERTY_NAME];
    })) {
      return {
        icon: _vector_layer.noResultsIcon,
        tooltipContent: _i18n.i18n.translate('xpack.maps.vectorLayer.noResultsFoundInJoinTooltip', {
          defaultMessage: `No matching results found in term joins`
        })
      };
    }
    const sourceDataRequest = this.getSourceDataRequest();
    const {
      tooltipContent,
      areResultsTrimmed,
      isDeprecated
    } = this.getSource().getSourceStatus(sourceDataRequest);
    return {
      icon: isDeprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 9
        }
      }) : this.getCurrentStyle().getIcon(isTocIcon && areResultsTrimmed),
      tooltipContent,
      areResultsTrimmed
    };
  }
  getFeatureId(feature) {
    var _feature$properties2;
    return (_feature$properties2 = feature.properties) === null || _feature$properties2 === void 0 ? void 0 : _feature$properties2[_constants.GEOJSON_FEATURE_ID_PROPERTY_NAME];
  }
  getFeatureById(id) {
    const featureCollection = this._getSourceFeatureCollection();
    if (!featureCollection) {
      return null;
    }
    const targetFeature = featureCollection.features.find(feature => {
      return this.getFeatureId(feature) === id;
    });
    return targetFeature ? targetFeature : null;
  }
  async getStyleMetaDescriptorFromLocalFeatures() {
    const sourceDataRequest = this.getSourceDataRequest();
    const style = this.getCurrentStyle();
    if (!style || !sourceDataRequest) {
      return null;
    }
    return await (0, _pluck_style_meta_from_features.pluckStyleMetaFromFeatures)(_lodash.default.get(sourceDataRequest.getData(), 'features', []), await this.getSource().getSupportedShapeTypes(), this.getCurrentStyle().getDynamicPropertiesArray());
  }
  getErrors(inspectorAdapters) {
    const errors = super.getErrors(inspectorAdapters);
    this.getValidJoins().forEach(join => {
      const joinDescriptor = join.toDescriptor();
      if (joinDescriptor.error) {
        errors.push({
          title: _i18n.i18n.translate('xpack.maps.geojsonVectorLayer.joinErrorTitle', {
            defaultMessage: `An error occurred when adding join metrics to layer features`
          }),
          body: joinDescriptor.error
        });
      }
    });
    return errors;
  }
  _requiresPrevSourceCleanup(mbMap) {
    const mbSource = mbMap.getSource(this.getMbSourceId());
    if (!mbSource) {
      return false;
    }
    return mbSource.type !== 'geojson';
  }
  syncLayerWithMB(mbMap, timeslice) {
    this._removeStaleMbSourcesAndLayers(mbMap);
    const mbSourceId = this.getMbSourceId();
    const mbSource = mbMap.getSource(mbSourceId);
    if (!mbSource) {
      mbMap.addSource(mbSourceId, {
        type: 'geojson',
        data: _constants.EMPTY_FEATURE_COLLECTION
      });
    }
    this._syncFeatureCollectionWithMb(mbMap);
    const timesliceMaskConfig = this._getTimesliceMaskConfig(timeslice);
    this._setMbLabelProperties(mbMap, undefined, timesliceMaskConfig);
    this._setMbPointsProperties(mbMap, undefined, timesliceMaskConfig);
    this._setMbLinePolygonProperties(mbMap, undefined, timesliceMaskConfig);
  }
  _getJoinFilterExpression() {
    return this.hasJoins() ?
    // Remove unjoined source features by filtering out features without GeoJSON feature.property[FEATURE_VISIBLE_PROPERTY_NAME] is true
    ['==', ['get', _constants.FEATURE_VISIBLE_PROPERTY_NAME], true] : undefined;
  }
  _syncFeatureCollectionWithMb(mbMap) {
    const mbGeoJSONSource = mbMap.getSource(this.getId());
    const featureCollection = this._getSourceFeatureCollection();
    const featureCollectionOnMap = _layer.AbstractLayer.getBoundDataForSource(mbMap, this.getId());
    if (!featureCollection) {
      if (featureCollectionOnMap) {
        this.getCurrentStyle().clearFeatureState(featureCollectionOnMap, mbMap, this.getId());
      }
      mbGeoJSONSource.setData(_constants.EMPTY_FEATURE_COLLECTION);
      return;
    }

    // "feature-state" data expressions are not supported with layout properties.
    // To work around this limitation,
    // scaled layout properties (like icon-size) must fall back to geojson property values :(
    const hasGeoJsonProperties = this.getCurrentStyle().setFeatureStateAndStyleProps(featureCollection, mbMap, this.getId());
    if (featureCollection !== featureCollectionOnMap || hasGeoJsonProperties) {
      mbGeoJSONSource.setData(featureCollection);
    }
  }
  _getTimesliceMaskConfig(timeslice) {
    var _this$getSourceDataRe;
    if (!timeslice || this.hasJoins()) {
      return;
    }
    const prevMeta = (_this$getSourceDataRe = this.getSourceDataRequest()) === null || _this$getSourceDataRe === void 0 ? void 0 : _this$getSourceDataRe.getMeta();
    return prevMeta !== undefined && prevMeta.timesliceMaskField !== undefined ? {
      timesliceMaskField: prevMeta.timesliceMaskField,
      timeslice
    } : undefined;
  }
  async syncData(syncContext) {
    await this._syncData(syncContext, this.getSource(), this.getCurrentStyle());
  }
  _isLoadingBounds() {
    const boundsDataRequest = this.getDataRequest(_constants.SOURCE_BOUNDS_DATA_REQUEST_ID);
    return !!boundsDataRequest && boundsDataRequest.isLoading();
  }

  // TLDR: Do not call getSource or getCurrentStyle in syncData flow. Use 'source' and 'style' arguments instead.
  //
  // 1) State is contained in the redux store. Layer instance state is readonly.
  // 2) Even though data request descriptor updates trigger new instances for rendering,
  // syncing data executes on a single object instance. Syncing data can not use updated redux store state.
  //
  // Blended layer data syncing branches on the source/style depending on whether clustering is used or not.
  // Given 1 above, which source/style to use can not be stored in Layer instance state.
  // Given 2 above, which source/style to use can not be pulled from data request state.
  // Therefore, source and style are provided as arugments and must be used instead of calling getSource or getCurrentStyle.
  async _syncData(syncContext, source, style) {
    if (this._isLoadingBounds()) {
      return;
    }
    try {
      await this._syncSourceStyleMeta(syncContext, source, style);
      await this._syncSourceFormatters(syncContext, source, style);
      const sourceResult = await (0, _geojson_source_data.syncGeojsonSourceData)({
        layerId: this.getId(),
        layerName: await this.getDisplayName(source),
        prevDataRequest: this.getSourceDataRequest(),
        requestMeta: await this._getVectorSourceRequestMeta(syncContext.isForceRefresh, syncContext.dataFilters, source, style, syncContext.isFeatureEditorOpenForLayer),
        syncContext,
        source,
        getUpdateDueToTimeslice: timeslice => {
          return this._getUpdateDueToTimesliceFromSourceRequestMeta(source, timeslice);
        }
      });
      await this._syncSupportsFeatureEditing({
        syncContext,
        source
      });
      if (!sourceResult.featureCollection || !sourceResult.featureCollection.features.length || !this.hasJoins()) {
        return;
      }
      const joinStates = await this._syncJoins(syncContext, style, sourceResult.featureCollection);
      await (0, _perform_inner_joins.performInnerJoins)(sourceResult, joinStates, syncContext.updateSourceData, syncContext.setJoinError);
    } catch (error) {
      // Error used to stop execution flow. Error state stored in data request and displayed to user in layer legend.
    }
  }
  _getSourceFeatureCollection() {
    const sourceDataRequest = this.getSourceDataRequest();
    return sourceDataRequest ? sourceDataRequest.getData() : null;
  }
  _getUpdateDueToTimesliceFromSourceRequestMeta(source, timeslice) {
    const prevDataRequest = this.getSourceDataRequest();
    const prevMeta = prevDataRequest === null || prevDataRequest === void 0 ? void 0 : prevDataRequest.getMeta();
    if (!prevMeta) {
      return true;
    }
    return source.getUpdateDueToTimeslice(prevMeta, timeslice);
  }
}
exports.GeoJsonVectorLayer = GeoJsonVectorLayer;