"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementItem = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ManagementItem {
  constructor({
    id,
    title,
    tip,
    order = 100,
    hideFromSidebar = false,
    euiIconType,
    icon,
    capabilitiesId,
    redirectFrom
  }) {
    (0, _defineProperty2.default)(this, "id", '');
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "tip", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    (0, _defineProperty2.default)(this, "hideFromSidebar", void 0);
    (0, _defineProperty2.default)(this, "euiIconType", void 0);
    (0, _defineProperty2.default)(this, "icon", void 0);
    (0, _defineProperty2.default)(this, "capabilitiesId", void 0);
    (0, _defineProperty2.default)(this, "redirectFrom", void 0);
    (0, _defineProperty2.default)(this, "enabled", true);
    this.id = id;
    this.title = title;
    this.tip = tip;
    this.order = order;
    this.hideFromSidebar = hideFromSidebar;
    this.euiIconType = euiIconType;
    this.icon = icon;
    this.capabilitiesId = capabilitiesId;
    this.redirectFrom = redirectFrom;
  }
  disable() {
    this.enabled = false;
  }
  enable() {
    this.enabled = true;
  }
}
exports.ManagementItem = ManagementItem;