"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogAIAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/log_ai_assistant/log_ai_assistant.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogAIAssistant = ({
  doc,
  observabilityAIAssistant: {
    ObservabilityAIAssistantContextualInsight,
    getContextualInsightMessages
  }
}) => {
  const explainLogMessageMessages = (0, _react.useMemo)(() => {
    if (!doc) {
      return undefined;
    }
    const message = (0, _discoverUtils.getMessageFieldWithFallbacks)(doc);
    if (!message) {
      return undefined;
    }
    return getContextualInsightMessages({
      message: 'Can you explain what this log message means? Where it could be coming from, whether it is expected and whether it is an issue.',
      instructions: JSON.stringify({
        logEntry: {
          fields: doc.fields
        }
      })
    });
  }, [doc, getContextualInsightMessages]);
  const similarLogMessageMessages = (0, _react.useMemo)(() => {
    var _doc$fields$find;
    if (!doc) {
      return undefined;
    }
    const message = (_doc$fields$find = doc.fields.find(field => field.field === 'message')) === null || _doc$fields$find === void 0 ? void 0 : _doc$fields$find.value[0];
    if (!message) {
      return undefined;
    }
    return getContextualInsightMessages({
      message: `I'm looking at a log entry. Can you construct a Kibana KQL query that I can enter in the search bar that gives me similar log entries, based on the message field?`,
      instructions: JSON.stringify({
        message
      })
    });
  }, [getContextualInsightMessages, doc]);
  const hasAtLeastOnePrompt = Boolean(explainLogMessageMessages || similarLogMessageMessages);
  return hasAtLeastOnePrompt ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, ObservabilityAIAssistantContextualInsight && explainLogMessageMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _translations.explainLogMessageTitle,
    messages: explainLogMessageMessages,
    dataTestSubj: "obsAiAssistantInsightButtonExplainLogMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })) : null, ObservabilityAIAssistantContextualInsight && similarLogMessageMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _translations.similarLogMessagesTitle,
    messages: similarLogMessageMessages,
    dataTestSubj: "obsAiAssistantInsightButtonSimilarLogMessage",
    showElasticLlmCallout: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })) : null) : null;
};

// eslint-disable-next-line import/no-default-export
exports.LogAIAssistant = LogAIAssistant;
var _default = exports.default = LogAIAssistant;