"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugeDimensionEditor = GaugeDimensionEditor;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _coloring = require("@kbn/coloring");
var _common = require("@kbn/expression-gauge-plugin/common");
var _public = require("@kbn/expression-gauge-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _react2 = require("@emotion/react");
var _utils = require("../../../common/expressions/impl/datatable/utils");
var _shared_components = require("../../shared_components");
var _palette_config = require("./palette_config");
var _utils2 = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/gauge/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GaugeDimensionEditor(props) {
  var _frame$activeData;
  const {
    state,
    setState,
    frame,
    accessor,
    isInlineEditing
  } = props;
  if ((state === null || state === void 0 ? void 0 : state.metricAccessor) !== accessor) return null;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];
  const [firstRow] = (currentData === null || currentData === void 0 ? void 0 : currentData.rows) || [];
  if (accessor == null || firstRow == null || !(0, _utils.isNumericFieldForDatatable)(currentData, accessor)) {
    return null;
  }
  const accessors = (0, _utils2.getAccessorsFromState)(state);
  const hasDynamicColoring = (state === null || state === void 0 ? void 0 : state.colorMode) === 'palette';
  const currentMinMax = {
    min: (0, _public.getMinValue)(firstRow, accessors),
    max: (0, _public.getMaxValue)(firstRow, accessors)
  };
  const activePalette = (state === null || state === void 0 ? void 0 : state.palette) || {
    type: 'palette',
    name: _palette_config.defaultPaletteParams.name,
    params: {
      ..._palette_config.defaultPaletteParams,
      continuity: 'all',
      colorStops: undefined,
      stops: undefined,
      rangeMin: currentMinMax.min,
      rangeMax: currentMinMax.max * 3 / 4
    }
  };
  const displayStops = (0, _coloring.applyPaletteParams)(props.paletteService, activePalette, currentMinMax);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.gauge.dynamicColoring.label', {
      defaultMessage: 'Band colors'
    }),
    css: (0, _react2.css)`
          align-items: center;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "lnsDynamicColoringGaugeSwitch",
    compressed: true,
    label: "",
    showLabel: false,
    checked: hasDynamicColoring,
    onChange: e => {
      const {
        checked
      } = e.target;
      const params = checked ? {
        palette: {
          ...activePalette,
          params: {
            ...activePalette.params,
            stops: displayStops
          }
        },
        ticksPosition: _common.GaugeTicksPositions.BANDS,
        colorMode: _common.GaugeColorModes.PALETTE
      } : {
        ticksPosition: _common.GaugeTicksPositions.AUTO,
        colorMode: _common.GaugeColorModes.NONE
      };
      setState({
        ...state,
        ...params
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })), hasDynamicColoring && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteMetricGradient.label', {
      defaultMessage: 'Color mapping'
    }),
    css: (0, _react2.css)`
              align-items: center;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    palette: displayStops.map(({
      color
    }) => color),
    siblingRef: props.panelRef,
    isInlineEditing: isInlineEditing,
    title: _i18n.i18n.translate('xpack.lens.paletteMetricGradient.label', {
      defaultMessage: 'Color mapping'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    setPalette: newPalette => {
      // if the new palette is not custom, replace the rangeMin with the artificial one
      if (newPalette.name !== _coloring.CUSTOM_PALETTE && newPalette.params && newPalette.params.rangeMin !== currentMinMax.min) {
        newPalette.params.rangeMin = currentMinMax.min;
      }
      setState({
        ...state,
        palette: newPalette
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
      position: "top",
      tooltipContent: _i18n.i18n.translate('xpack.lens.shared.ticksPositionOptionsTooltip', {
        defaultMessage: 'Places ticks on each band border instead of distributing them evenly'
      }),
      condition: true,
      delay: "regular",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.shared.ticksPositionOptions', {
      defaultMessage: 'Ticks on bands'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued",
      size: "s",
      className: "eui-alignTop",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 19
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.shared.ticksPositionOptions', {
      defaultMessage: 'Ticks on bands'
    }),
    "data-test-subj": "lens-toolbar-gauge-ticks-position-switch",
    showLabel: false,
    checked: state.ticksPosition === _common.GaugeTicksPositions.BANDS,
    onChange: () => {
      setState({
        ...state,
        ticksPosition: state.ticksPosition === _common.GaugeTicksPositions.BANDS ? _common.GaugeTicksPositions.AUTO : _common.GaugeTicksPositions.BANDS
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }))));
}