"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnCellValueActions = getColumnCellValueActions;
exports.getColumnsFilterable = getColumnsFilterable;
exports.getDatatableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _ebtTools = require("@kbn/ebt-tools");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _table_basic = require("./components/table_basic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getColumnsFilterable(table, handlers) {
  if (!table.rows.length) {
    return;
  }

  // to avoid false negatives, find the first index of the row with data for each column
  const rowsWithDataForEachColumn = table.columns.map((column, colIndex) => {
    const rowIndex = table.rows.findIndex(row => row[column.id] != null);
    return [rowIndex > -1 ? rowIndex : 0, colIndex];
  });
  return Promise.all(rowsWithDataForEachColumn.map(async ([rowIndex, colIndex]) => {
    var _handlers$hasCompatib;
    return Boolean(await ((_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.call(handlers, {
      name: 'filter',
      data: {
        data: [{
          table,
          column: colIndex,
          row: rowIndex
        }]
      }
    })));
  }));
}

/**
 * Retrieves the compatible CELL_VALUE_TRIGGER actions indexed by column
 **/
async function getColumnCellValueActions(config, getCompatibleCellValueActions) {
  if (!config.data || !getCompatibleCellValueActions) {
    return [];
  }
  return Promise.all(config.data.columns.map(({
    meta: columnMeta
  }) => {
    try {
      return getCompatibleCellValueActions([{
        columnMeta
      }]);
    } catch {
      return [];
    }
  }));
}
const getDatatableRenderer = dependencies => ({
  name: 'lens_datatable_renderer',
  displayName: _i18n.i18n.translate('xpack.lens.datatable.visualizationName', {
    defaultMessage: 'Datatable'
  }),
  help: '',
  validate: () => undefined,
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const performanceTracker = (0, _ebtTools.createPerformanceTracker)({
      type: _ebtTools.PERFORMANCE_TRACKER_TYPES.PANEL,
      subType: 'lens_datatable_renderer'
    });
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.PRE_RENDER);
    handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
    const resolvedGetType = await dependencies.getType;
    const getType = meta => {
      var _meta$sourceParams;
      if ((meta === null || meta === void 0 ? void 0 : (_meta$sourceParams = meta.sourceParams) === null || _meta$sourceParams === void 0 ? void 0 : _meta$sourceParams.type) === undefined) return;
      return resolvedGetType(String(meta.sourceParams.type));
    };
    const {
      hasCompatibleActions,
      isInteractive,
      getCompatibleCellValueActions
    } = handlers;
    const renderComplete = () => {
      performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_COMPLETE);
      (0, _lens_ui_telemetry.trackUiCounterEvents)('table', handlers.getExecutionContext());
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);

    // An entry for each table row, whether it has any actions attached to
    // ROW_CLICK_TRIGGER trigger.
    let rowHasRowClickTriggerActions = [];
    if (hasCompatibleActions) {
      if (!!config.data) {
        rowHasRowClickTriggerActions = await Promise.all(config.data.rows.map(async (_row, rowIndex) => {
          try {
            const hasActions = await hasCompatibleActions({
              name: 'tableRowContextMenuClick',
              data: {
                rowIndex,
                table: config.data,
                columns: config.args.columns.map(column => column.columnId)
              }
            });
            return hasActions;
          } catch {
            return false;
          }
        }));
      }
    }
    const [startServices] = await dependencies.core.getStartServices();
    const [columnCellValueActions, columnsFilterable] = await Promise.all([getColumnCellValueActions(config, getCompatibleCellValueActions), getColumnsFilterable(config.data, handlers)]);
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_START);
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_table_basic.DatatableComponent, (0, _extends2.default)({}, config, {
      formatFactory: dependencies.formatFactory,
      dispatchEvent: handlers.event,
      renderMode: handlers.getRenderMode(),
      paletteService: dependencies.paletteService,
      getType: getType,
      rowHasRowClickTriggerActions: rowHasRowClickTriggerActions,
      columnCellValueActions: columnCellValueActions,
      columnFilterable: columnsFilterable,
      interactive: isInteractive(),
      theme: dependencies.core.theme,
      renderComplete: renderComplete,
      syncColors: config.syncColors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }))), domNode);
  }
});
exports.getDatatableRenderer = getDatatableRenderer;