"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyValueTable = KeyValueTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _formatted_value = require("./formatted_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-key-value-metadata-table/src/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function KeyValueTable({
  keyValuePairs,
  tableProps = {}
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, (0, _extends2.default)({
    compressed: true
  }, tableProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, keyValuePairs.map(({
    key,
    value
  }) => {
    const asArray = (0, _lodash.castArray)(value);
    const valueList = asArray.length <= 1 ? /*#__PURE__*/_react.default.createElement(_formatted_value.FormattedValue, {
      value: asArray[0],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 15
      }
    }, asArray.map((val, index) => /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_value.FormattedValue, {
      key: index,
      value: val,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 21
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "dot-key",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 17
      }
    }, key)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 15
      }
    }, valueList));
  })));
}