"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _keyboard_shortcut = require("../../lib/keyboard_shortcut/keyboard_shortcut");
var _inspect_overlay = require("./overlay/inspect_overlay");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/inspect_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ARIA_LABEL = _i18n.i18n.translate('kbnInspectComponent.inspectButton.ariaLabel', {
  defaultMessage: 'Inspect component'
});
const TOOLTIP_CONTENT = _i18n.i18n.translate('kbnInspectComponent.inspectButton.tooltip', {
  values: {
    keyboardShortcut: (0, _keyboard_shortcut.isMac)() ? "⌘ '" : "Ctrl '"
  },
  defaultMessage: 'Keyboard shortcut {keyboardShortcut}'
});
/**
 * The entry point for the plugin. Toggles inspect mode.
 */
const InspectButton = ({
  core,
  branch
}) => {
  const [isInspecting, setIsInspecting] = (0, _react.useState)(false);
  const [flyoutOverlayRef, setFlyoutOverlayRef] = (0, _react.useState)(null);
  const buttonStyle = (0, _react2.css)`
    & > .euiButtonEmpty__content > svg {
      margin-left: 6px;
    }
  `;
  const handleKeydown = event => {
    if ((0, _keyboard_shortcut.isKeyboardShortcut)(event)) {
      event.preventDefault();
      setIsInspecting(prev => !prev);
    }
  };
  const handleTogglingInspectMode = () => {
    if (flyoutOverlayRef) {
      flyoutOverlayRef.close();
      setFlyoutOverlayRef(null);
    }
    setIsInspecting(prev => !prev);
  };

  /**
   * Prevent components from losing focus when toggling on inspect mode via InspectButton.
   * If a component loses focus, it might unmount itself.
   */
  const preventTargetFromLosingFocus = event => {
    event.preventDefault();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: handleKeydown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isInspecting ? '' : TOOLTIP_CONTENT,
    position: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
    onClick: handleTogglingInspectMode,
    onMouseDown: preventTargetFromLosingFocus,
    iconType: "inspect",
    isSelected: isInspecting,
    "aria-pressed": isInspecting,
    css: buttonStyle,
    "aria-label": ARIA_LABEL,
    "data-test-subj": "inspectComponentButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), isInspecting && /*#__PURE__*/_react.default.createElement(_inspect_overlay.InspectOverlay, {
    core: core,
    branch: branch,
    setFlyoutOverlayRef: setFlyoutOverlayRef,
    setIsInspecting: setIsInspecting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }));
};
exports.InspectButton = InspectButton;