"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _domToImageMore = _interopRequireDefault(require("dom-to-image-more"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/flyout/data_section/component_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-expect-error - this module has no exported types
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PREVIEW_ALT_TEXT = _i18n.i18n.translate('kbnInspectComponent.inspectFlyout.dataSection.previewImageAltText', {
  defaultMessage: 'Preview of the component associated with the selected element'
});
const PREVIEW_BADGE_LABEL = _i18n.i18n.translate('kbnInspectComponent.inspectFlyout.dataSection.previewCardLabel', {
  defaultMessage: 'Component Preview'
});
/**
 * ComponentPreview component displays a preview of the source component associated with the inspected HTML element.
 */
const ComponentPreview = ({
  element
}) => {
  const [screenshot, setScreenshot] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const CARD_WIDTH = 280;
  const CARD_HEIGHT = 224;
  /**
   * IMAGE_SIZE is used to set the size of the EuiImage component.
   * Without it, the image would overflow the card in which it is contained.
   */
  const IMAGE_SIZE = 200;
  const cardCss = (0, _react2.css)`
    width: ${CARD_WIDTH}px;
    height: ${CARD_HEIGHT}px;
    margin: 0 auto;
  `;
  const badgeCss = (0, _react2.css)`
    user-select: none;
  `;
  (0, _react.useEffect)(() => {
    const generateScreenshot = async () => {
      try {
        const canvas = await _domToImageMore.default.toCanvas(element);
        setScreenshot(canvas.toDataURL('image/png'));
      } catch (err) {
        return;
      } finally {
        setIsLoading(false);
      }
    };
    if (element) {
      generateScreenshot();
    }
  }, [element]);
  if (!element) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: isLoading,
    contentAriaLabel: PREVIEW_ALT_TEXT,
    width: CARD_WIDTH,
    height: CARD_HEIGHT,
    borderRadius: "none",
    "data-test-subj": "inspectFlyoutPreviewImage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: "",
    betaBadgeProps: {
      label: PREVIEW_BADGE_LABEL,
      css: badgeCss
    },
    css: cardCss,
    paddingSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: PREVIEW_ALT_TEXT,
    src: screenshot,
    size: IMAGE_SIZE,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
};
exports.ComponentPreview = ComponentPreview;