"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDocumentForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _use_is_mounted = require("../../../../use_is_mounted");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_tabs/tab_documents/add_document_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const {
  emptyField
} = _shared_imports.fieldValidators;
const i18nTexts = {
  addDocumentButton: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.addDocumentButtonLabel', {
    defaultMessage: 'Add document'
  }),
  addDocumentErrorMessage: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.addDocumentErrorMessage', {
    defaultMessage: 'Error adding document'
  }),
  addDocumentSuccessMessage: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.addDocumentSuccessMessage', {
    defaultMessage: 'Document added'
  }),
  indexField: {
    fieldLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.indexFieldLabel', {
      defaultMessage: 'Index'
    }),
    validationMessage: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.indexRequiredErrorMessage', {
      defaultMessage: 'An index name is required.'
    })
  },
  idField: {
    fieldLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.idFieldLabel', {
      defaultMessage: 'Document ID'
    }),
    validationMessage: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocuments.idRequiredErrorMessage', {
      defaultMessage: 'A document ID is required.'
    })
  }
};
const fieldsConfig = {
  index: {
    label: i18nTexts.indexField.fieldLabel,
    validations: [{
      validator: emptyField(i18nTexts.indexField.validationMessage)
    }]
  },
  id: {
    label: i18nTexts.idField.fieldLabel,
    validations: [{
      validator: emptyField(i18nTexts.idField.validationMessage)
    }]
  }
};
const AddDocumentForm = ({
  onAddDocuments
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const isMounted = (0, _use_is_mounted.useIsMounted)();
  const [isLoadingDocument, setIsLoadingDocument] = (0, _react.useState)(false);
  const [documentError, setDocumentError] = (0, _react.useState)(undefined);
  const [isDocumentAdded, setIsDocumentAdded] = (0, _react.useState)(false);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      index: '',
      id: ''
    }
  });
  const submitForm = async e => {
    const {
      isValid,
      data
    } = await form.submit();
    const {
      id,
      index
    } = data;
    if (isValid) {
      setIsLoadingDocument(true);
      setDocumentError(undefined);
      setIsDocumentAdded(false);
      const {
        error,
        data: document
      } = await services.api.loadDocument(index, id);
      if (!isMounted.current) {
        return;
      }
      setIsLoadingDocument(false);
      if (error) {
        setDocumentError(error);
        return;
      }
      setIsDocumentAdded(true);
      onAddDocuments(document);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    onSubmit: submitForm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, documentError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.addDocumentErrorMessage,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "addDocumentError",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, documentError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "index",
    component: _shared_imports.TextField,
    config: fieldsConfig.index,
    componentProps: {
      ['data-test-subj']: 'indexField'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "id",
    component: _shared_imports.TextField,
    config: fieldsConfig.id,
    componentProps: {
      ['data-test-subj']: 'idField'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: submitForm,
    "data-test-subj": "addDocumentButton",
    isLoading: isLoadingDocument,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, i18nTexts.addDocumentButton)), isDocumentAdded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    "data-test-subj": "addDocumentSuccess",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 17
    }
  }, i18nTexts.addDocumentSuccessMessage))))));
};
exports.AddDocumentForm = AddDocumentForm;