"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/field_components/text_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const styles = {
  panel: (0, _react2.css)`
    box-shadow: none;
  `
};
const TextEditor = ({
  field,
  editorProps,
  euiFieldProps
}) => {
  const {
    value,
    helpText,
    setValue,
    label
  } = field;
  const {
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    isInvalid: typeof errorMessage === 'string',
    error: errorMessage,
    fullWidth: true,
    labelAppend: editorProps.labelAppend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    paddingSize: "s",
    hasShadow: false
  }, euiFieldProps, {
    css: styles.panel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.CodeEditor, (0, _extends2.default)({
    value: value,
    onChange: setValue
  }, editorProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }))));
};
exports.TextEditor = TextEditor;