"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_unified_search = require("../../hooks/use_unified_search");
var _asset_details = require("../../../../../components/asset_details");
var _asset_details_tabs = require("../../../../../common/asset_details_config/asset_details_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/host_details_flyout/flyout_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FlyoutWrapper = ({
  node: {
    name
  },
  closeFlyout
}) => {
  const {
    parsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  return /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    entityId: name,
    entityName: name,
    entityType: "host",
    dateRange: parsedDateRange,
    overrides: {
      metadata: {
        showActionsColumn: true
      }
    },
    tabs: _asset_details_tabs.hostDetailsTabs,
    links: ['nodeDetails'],
    renderMode: {
      mode: 'flyout',
      closeFlyout
    },
    preferredSchema: searchCriteria.preferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};
exports.FlyoutWrapper = FlyoutWrapper;