"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRatePageContent = exports.AnomaliesPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _public = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _loading_page = require("../../../components/loading_page");
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _log_analysis2 = require("../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../containers/logs/log_analysis/modules/log_entry_rate");
var _page_template = require("../shared/page_template");
var _page_results_content = require("./page_results_content");
var _page_setup_content = require("./page_setup_content");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_rate/page_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JOB_STATUS_POLLING_INTERVAL = 30000;
const logsAnomaliesTitle = _i18n.i18n.translate('xpack.infra.logs.anomaliesPageTitle', {
  defaultMessage: 'Anomalies'
});
const LogEntryRatePageContent = exports.LogEntryRatePageContent = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis2.useLogAnalysisCapabilitiesContext)();
  const {
    fetchJobStatus: fetchLogEntryCategoriesJobStatus,
    fetchModuleDefinition: fetchLogEntryCategoriesModuleDefinition,
    jobStatus: logEntryCategoriesJobStatus,
    setupStatus: logEntryCategoriesSetupStatus
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const {
    fetchJobStatus: fetchLogEntryRateJobStatus,
    fetchModuleDefinition: fetchLogEntryRateModuleDefinition,
    jobStatus: logEntryRateJobStatus,
    setupStatus: logEntryRateSetupStatus
  } = (0, _log_entry_rate.useLogEntryRateModuleContext)();
  const {
    showModuleList
  } = (0, _setup_flyout.useLogAnalysisSetupFlyoutStateContext)();
  const fetchAllJobStatuses = (0, _react.useCallback)(() => Promise.all([fetchLogEntryCategoriesJobStatus(), fetchLogEntryRateJobStatus()]), [fetchLogEntryCategoriesJobStatus, fetchLogEntryRateJobStatus]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchAllJobStatuses();
    }
  }, [fetchAllJobStatuses, hasLogAnalysisReadCapabilities]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchLogEntryCategoriesModuleDefinition();
    }
  }, [fetchLogEntryCategoriesModuleDefinition, hasLogAnalysisReadCapabilities]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchLogEntryRateModuleDefinition();
    }
  }, [fetchLogEntryRateModuleDefinition, hasLogAnalysisReadCapabilities]);
  (0, _useInterval.default)(() => {
    if (logEntryCategoriesSetupStatus.type !== 'pending' && hasLogAnalysisReadCapabilities) {
      fetchLogEntryCategoriesJobStatus();
    }
    if (logEntryRateSetupStatus.type !== 'pending' && hasLogAnalysisReadCapabilities) {
      fetchLogEntryRateJobStatus();
    }
  }, JOB_STATUS_POLLING_INTERVAL);
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  if (logEntryCategoriesSetupStatus.type === 'initializing' || logEntryRateSetupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      message: _i18n.i18n.translate('xpack.infra.logs.analysisPage.loadingMessage', {
        defaultMessage: 'Checking status of analysis jobs...'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    });
  } else if (logEntryCategoriesSetupStatus.type === 'unknown' || logEntryRateSetupStatus.type === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.LogAnalysisSetupStatusUnknownPrompt, {
      retry: fetchAllJobStatuses,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }));
  } else if ((0, _log_analysis.isJobStatusWithResults)(logEntryCategoriesJobStatus[_log_analysis.logEntryCategoriesJobType]) || (0, _log_analysis.isJobStatusWithResults)(logEntryRateJobStatus[_log_analysis.logEntryRateJobType])) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_results_content.LogEntryRateResultsContent, {
      idFormats: idFormats,
      pageTitle: logsAnomaliesTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }));
  } else if (!hasLogAnalysisSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }), ";");
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_page_setup_content.LogEntryRateSetupContent, {
      onOpenSetup: showModuleList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }));
  }
});
const AnomaliesPageTemplate = ({
  children,
  ...rest
}) => {
  const {
    logViewStatus
  } = (0, _public.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, (0, _extends2.default)({
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    "data-test-subj": "logsLogEntryRatePage",
    pageHeader: rest.isEmptyState ? undefined : {
      pageTitle: logsAnomaliesTitle
    }
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }), children);
};
exports.AnomaliesPageTemplate = AnomaliesPageTemplate;