"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactQueryProvider = ReactQueryProvider;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/containers/react_query_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_CONFIG = {
  defaultOptions: {
    queries: {
      keepPreviousData: true,
      refetchOnWindowFocus: false
    }
  }
};
function ReactQueryProvider({
  children,
  config = {}
}) {
  const [queryClient] = (0, _react.useState)(() => new _reactQuery.QueryClient((0, _lodash.merge)(DEFAULT_CONFIG, config)));
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(HideableReactQueryDevTools, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), children);
}
function HideableReactQueryDevTools() {
  const [isHidden, setIsHidden] = (0, _react.useState)(false);
  return !isHidden && process.env.NODE_ENV === 'development' ? /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraHideableReactQueryDevToolsButton",
    iconType: "cross",
    color: "primary",
    css: {
      zIndex: 99999,
      position: 'fixed',
      bottom: '40px',
      left: '40px'
    },
    onClick: () => setIsHidden(!isHidden),
    "aria-label": _i18n.i18n.translate('xpack.infra.hideableReactQueryDevTools.euiButtonIcon.disableReactQueryDevLabel', {
      defaultMessage: 'Disable React Query Dev Tools'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  })) : null;
}