"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threads = Threads;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_kibana = require("../../../../hooks/use_kibana");
var _profiling_links = require("./profiling_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/profiling/threads.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Threads({
  kuery
}) {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    getDateRangeInTimestamp,
    dateRange,
    setDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    from,
    to
  } = getDateRangeInTimestamp();
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const stacktracesProfilingLinkLocator = services.observabilityShared.locators.profiling.stacktracesLocator;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_profiling_links.ProfilingLinks, {
    hostname: entity.name,
    from: dateRange.from,
    to: dateRange.to,
    profilingLinkLocator: stacktracesProfilingLinkLocator,
    profilingLinkLabel: _i18n.i18n.translate('xpack.infra.flamegraph.profilingAppThreadsLink', {
      defaultMessage: 'Go to Universal Profiling Threads'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.EmbeddableStackTraces, {
    type: _profilingUtils.TopNType.Threads,
    rangeFrom: from,
    rangeTo: to,
    kuery: kuery,
    onClick: category => {
      stacktracesProfilingLinkLocator.navigate({
        type: _profilingUtils.TopNType.Traces,
        rangeFrom: dateRange.from,
        rangeTo: dateRange.to,
        kuery: `(${kuery}) AND process.thread.name:"${category}"`
      });
    },
    onChartBrushEnd: range => {
      setDateRange({
        from: range.rangeFrom,
        to: range.rangeTo
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
}