"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldsListItemContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mappings_state_context = require("../../mappings_state_context");
var _runtimefields_list_item = require("./runtimefields_list_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/runtime_fields/runtimefields_list_item_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuntimeFieldsListItemContainer = ({
  fieldId
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    runtimeFieldsList: {
      status,
      fieldToEdit
    },
    runtimeFields
  } = (0, _mappings_state_context.useMappingsState)();
  const getField = (0, _react.useCallback)(id => runtimeFields[id], [runtimeFields]);
  const field = getField(fieldId);
  const isHighlighted = fieldToEdit === fieldId;
  const isDimmed = status === 'editingField' && fieldToEdit !== fieldId;
  const areActionButtonsVisible = status === 'idle';
  const editField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'runtimeFieldsList.editField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_runtimefields_list_item.RuntimeFieldsListItem, {
    field: field,
    isHighlighted: isHighlighted,
    isDimmed: isDimmed,
    areActionButtonsVisible: areActionButtonsVisible,
    editField: editField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
};
exports.RuntimeFieldsListItemContainer = RuntimeFieldsListItemContainer;