"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerParameterSelects = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/analyzer_parameter_selects.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const areOptionsSuperSelect = options => {
  if (!options || !Boolean(options.length)) {
    return false;
  }
  // `Select` options have a "text" property, `SuperSelect` options don't have it.
  return {}.hasOwnProperty.call(options[0], 'text') === false;
};
const AnalyzerParameterSelects = ({
  onChange,
  mainDefaultValue,
  subDefaultValue,
  config,
  options,
  mapOptionsToSubOptions,
  'data-test-subj': dataTestSubj
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      main: mainDefaultValue,
      sub: subDefaultValue
    }
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updateData => {
      const formData = updateData.data.internal;
      const value = formData.sub ? formData.sub : formData.main;
      onChange(value);
    });
    return subscription.unsubscribe;
  }, [subscribe, onChange]);
  const getSubOptionsMeta = (0, _react.useCallback)(mainValue => mapOptionsToSubOptions !== undefined ? mapOptionsToSubOptions[mainValue] : undefined, [mapOptionsToSubOptions]);
  const onMainValueChange = (0, _react.useCallback)(mainValue => {
    const subOptionsMeta = getSubOptionsMeta(mainValue);
    form.setFieldValue('sub', subOptionsMeta ? subOptionsMeta.options[0].value : undefined);
  }, [form, getSubOptionsMeta]);
  const renderSelect = (field, opts) => {
    const isSuperSelect = areOptionsSuperSelect(opts);
    return isSuperSelect ? /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
      field: field,
      euiFieldProps: {
        options: opts
      },
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_shared_imports.SelectField, {
      field: field,
      euiFieldProps: {
        options: opts,
        hasNoInitialSelection: false
      },
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "main",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, ({
    main
  }) => {
    const subOptions = getSubOptionsMeta(main);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "main",
      config: config,
      onChange: onMainValueChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 17
      }
    }, field => renderSelect(field, options))), subOptions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "sub",
      config: {
        ...config,
        defaultValue: subOptions.options[0].value,
        label: subOptions.label
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    }, field => renderSelect(field, subOptions.options))));
  }));
};
exports.AnalyzerParameterSelects = AnalyzerParameterSelects;