"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewPolicyFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _ui_metric = require("../../../services/ui_metric");
var _policies = require("../../../lib/policies");
var _navigation = require("../../../services/navigation");
var _constants = require("../../../constants");
var _use_is_read_only = require("../../../lib/use_is_read_only");
var _policy_list_context = require("../policy_list_context");
var _components = require("../components");
var _hot_phase = require("./hot_phase");
var _warm_phase = require("./warm_phase");
var _timeline = require("./timeline");
var _cold_phase = require("./cold_phase");
var _delete_phase = require("./delete_phase");
var _frozen_phase = require("./frozen_phase");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/policy_flyout/view_policy_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewPolicyFlyout = ({
  policy
}) => {
  var _policy$policy, _policy$policy$_meta;
  const isReadOnly = (0, _use_is_read_only.useIsReadOnly)();
  const {
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const onClose = () => {
    history.push((0, _navigation.getPoliciesListPath)());
  };
  const onEdit = policyName => {
    (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, _constants.UIM_EDIT_CLICK);
    history.push((0, _navigation.getPolicyEditPath)(policyName));
  };
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const actionMenuItems = [
  /**
   * Edit policy
   */
  {
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.editActionLabel', {
      defaultMessage: 'Edit'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }),
    onClick: () => onEdit(policy.name)
  },
  /**
   * Add policy to index template
   */
  {
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.addToIndexTemplate', {
      defaultMessage: 'Add to index template'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "plusInCircle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }),
    onClick: () => setListAction({
      selectedPolicy: policy,
      actionType: 'addIndexTemplate'
    })
  }];
  /**
   * Delete policy
   */
  if (!(0, _policies.hasLinkedIndices)(policy)) {
    actionMenuItems.push({
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.deleteActionLabel', {
        defaultMessage: 'Delete'
      }),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 13
        }
      }),
      onClick: () => {
        setShowPopover(false);
        setListAction({
          selectedPolicy: policy,
          actionType: 'deletePolicy'
        });
      }
    });
  }
  const managePolicyButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.managePolicyActionsAriaLabel', {
      defaultMessage: 'Manage policy'
    }),
    onClick: () => setShowPopover(previousBool => !previousBool),
    iconType: "arrowUp",
    iconSide: "right",
    fill: true,
    "data-test-subj": "managePolicyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.managePolicyButtonLabel', {
    defaultMessage: 'Manage'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    closeButtonProps: {
      'data-test-subj': 'policyFlyoutCloseButton'
    },
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "policyFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, policy.name))), policy.policy.deprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_components.DeprecatedPolicyBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  })) : null, (_policy$policy = policy.policy) !== null && _policy$policy !== void 0 && (_policy$policy$_meta = _policy$policy._meta) !== null && _policy$policy$_meta !== void 0 && _policy$policy$_meta.managed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_components.ManagedPolicyBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    policy: policy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }), policy.policy.phases.hot && /*#__PURE__*/_react.default.createElement(_hot_phase.HotPhase, {
    phases: policy.policy.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 38
    }
  }), policy.policy.phases.warm && /*#__PURE__*/_react.default.createElement(_warm_phase.WarmPhase, {
    phases: policy.policy.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 39
    }
  }), policy.policy.phases.cold && /*#__PURE__*/_react.default.createElement(_cold_phase.ColdPhase, {
    phases: policy.policy.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 39
    }
  }), policy.policy.phases.frozen && /*#__PURE__*/_react.default.createElement(_frozen_phase.FrozenPhase, {
    phases: policy.policy.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 41
    }
  }), policy.policy.phases.delete && /*#__PURE__*/_react.default.createElement(_delete_phase.DeletePhase, {
    phases: policy.policy.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 41
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }))), !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: managePolicyButton,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.managePolicyTitle', {
        defaultMessage: 'Options'
      }),
      items: actionMenuItems
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  })))))));
};
exports.ViewPolicyFlyout = ViewPolicyFlyout;