"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instruction = Instruction;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content = require("./content");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/tutorial/instruction.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Instruction({
  commands,
  textPost,
  textPre,
  replaceTemplateStrings,
  customComponentName,
  variantId,
  isCloudEnabled
}) {
  var _theme$getTheme$darkM;
  const {
    tutorialService,
    http,
    theme,
    getBasePath,
    kibanaVersion
  } = (0, _kibana_services.getServices)();
  let pre;
  if (textPre) {
    pre = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPre),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }));
  }
  let post;
  if (textPost) {
    post = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPost),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }));
  }
  const customComponent = customComponentName ? tutorialService.getCustomComponent(customComponentName) : null;
  const LazyCustomComponent = (0, _react.useMemo)(() => {
    if (customComponent) {
      return /*#__PURE__*/_react.default.lazy(() => customComponent().then(component => ({
        default: component
      })));
    }
  }, [customComponent]);
  let commandBlock;
  if (commands) {
    const cmdText = commands.map(cmd => {
      return replaceTemplateStrings(cmd);
    }).join('\n');
    commandBlock = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, cmdText);
  }
  const darkTheme = (_theme$getTheme$darkM = theme === null || theme === void 0 ? void 0 : theme.getTheme().darkMode) !== null && _theme$getTheme$darkM !== void 0 ? _theme$getTheme$darkM : false;
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, pre, commandBlock, LazyCustomComponent && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 29
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(LazyCustomComponent, {
    basePath: getBasePath(),
    isDarkTheme: darkTheme,
    http: http,
    variantId: variantId,
    isCloudEnabled: isCloudEnabled,
    kibanaVersion: kibanaVersion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), post);
}