"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNodeEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _icon_renderer = require("../icon_renderer");
var _styles = require("../../styles");
var _control_plane = require("./control_plane.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/selected_node_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SelectedNodeEditor = ({
  workspace,
  selectedNode
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const groupButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.groupButtonTooltip', {
    defaultMessage: 'group the currently selected items into {latestSelectionLabel}',
    values: {
      latestSelectionLabel: selectedNode.label
    }
  });
  const ungroupButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.ungroupButtonTooltip', {
    defaultMessage: 'ungroup {latestSelectionLabel}',
    values: {
      latestSelectionLabel: selectedNode.label
    }
  });
  const onGroupButtonClick = () => {
    workspace.groupSelections(selectedNode);
  };
  const onClickUngroup = () => {
    workspace.ungroup(selectedNode);
  };
  const onChangeSelectedVertexLabel = event => {
    selectedNode.label = event.target.value;
    workspace.changeHandler();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarPanelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
    icon: selectedNode.icon,
    color: euiTheme.colors.darkShade,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), ' ', selectedNode.data.field, " ", selectedNode.data.term), (workspace.selectedNodes.length > 1 || workspace.selectedNodes.length > 0 && workspace.selectedNodes[0] !== selectedNode) && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: groupButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "fold",
    onClick: onGroupButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.sidebar.groupButtonLabel",
    defaultMessage: "group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }))), selectedNode.numChildren > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: ungroupButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "unfold",
    onClick: onClickUngroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.sidebar.ungroupButtonLabel",
    defaultMessage: "ungroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("form", {
    className: "form-horizontal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "form-group form-group-sm",
    css: _control_plane.gphFormGroupSmallStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "labelEdit",
    className: "col-sm-3 control-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.displayLabelLabel', {
    defaultMessage: 'Display label'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-9",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("input", {
    ref: element => element && (element.value = selectedNode.label),
    type: "text",
    id: "labelEdit",
    className: "form-control input-sm",
    onChange: onChangeSelectedVertexLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "help-block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.displayLabelHelpText', {
    defaultMessage: 'Change the label for this vertex.'
  }))))));
};
exports.SelectedNodeEditor = SelectedNodeEditor;