"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISIBLE_PLATFORM_OPTIONS = exports.PLATFORM_WITH_INSTALL_SERVERS = exports.KUBERNETES_PLATFORM_OPTION = exports.EXTENDED_PLATFORM_OPTIONS = void 0;
exports.usePlatform = usePlatform;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLATFORM_WITH_INSTALL_SERVERS = exports.PLATFORM_WITH_INSTALL_SERVERS = ['linux_aarch64', 'linux_x86_64', 'mac_aarch64', 'mac_x86_64', 'windows', 'windows_msi'];
const VISIBLE_PLATFORM_OPTIONS = exports.VISIBLE_PLATFORM_OPTIONS = [{
  id: 'linux_aarch64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux', {
    defaultMessage: 'Linux aarch64'
  }),
  'data-test-subj': 'platformTypeLinux'
}, {
  id: 'mac_aarch64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.mac', {
    defaultMessage: 'MacOS aarch64'
  }),
  'data-test-subj': 'platformTypeMac'
}, {
  id: 'deb_aarch64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.deb', {
    defaultMessage: 'DEB aarch64'
  }),
  'data-test-subj': 'platformTypeLinuxDeb'
}, {
  id: 'rpm_aarch64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.rpm', {
    defaultMessage: 'RPM aarch64'
  }),
  'data-test-subj': 'platformTypeLinuxRpm'
}];
const EXTENDED_PLATFORM_OPTIONS = exports.EXTENDED_PLATFORM_OPTIONS = [{
  id: 'windows',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.windows', {
    defaultMessage: 'Windows x86_64'
  })
}, {
  id: 'windows_msi',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.msi', {
    defaultMessage: 'Windows MSI'
  })
}, {
  id: 'linux_x86_64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux', {
    defaultMessage: 'Linux x86_64'
  })
}, {
  id: 'mac_x86_64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.mac', {
    defaultMessage: 'MacOS x86_64'
  })
}, {
  id: 'deb_x86_64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.deb', {
    defaultMessage: 'DEB x86_64'
  })
}, {
  id: 'rpm_x86_64',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.rpm', {
    defaultMessage: 'RPM x86_64'
  })
}];
const KUBERNETES_PLATFORM_OPTION = exports.KUBERNETES_PLATFORM_OPTION = {
  id: 'kubernetes',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.kubernetes', {
    defaultMessage: 'Kubernetes'
  }),
  'data-test-subj': 'platformTypeKubernetes'
};
function usePlatform(initialPlatform = 'linux_aarch64') {
  const [platform, setPlatform] = (0, _react.useState)(initialPlatform);
  return {
    platform,
    setPlatform
  };
}