"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/home_integration/tutorial_module_notice.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TutorialModuleNotice = /*#__PURE__*/(0, _react.memo)(({
  moduleName
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    application
  } = (0, _hooks.useStartServices)();
  const hasIntegrationsPermissions = application.capabilities.navLinks.integrations;
  const {
    data: packagesData,
    isLoading
  } = (0, _hooks.useGetPackages)();
  const pkgInfo = !isLoading && (packagesData === null || packagesData === void 0 ? void 0 : packagesData.items) && packagesData.items.find(pkg => pkg.name === moduleName && pkg.name !== _constants.FLEET_APM_PACKAGE); // APM needs special handling

  if (hasIntegrationsPermissions && pkgInfo) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.homeIntegration.tutorialModule.noticeText",
      defaultMessage: "{notePrefix} A newer version of this module is {availableAsIntegrationLink}. To learn more about integrations and the new Elastic Agent, read our {blogPostLink}.",
      values: {
        notePrefix: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "info",
          style: {
            verticalAlign: 'baseline'
          },
          "aria-label": _i18n.i18n.translate('xpack.fleet.homeIntegration.tutorialModule.noticeText.notePrefix', {
            defaultMessage: 'Note'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 19
          }
        }),
        availableAsIntegrationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getHref('integration_details_overview', {
            pkgkey: (0, _services.pkgKeyFromPackageInfo)(pkgInfo)
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.homeIntegration.tutorialModule.noticeText.integrationLink",
          defaultMessage: "available as an Elastic Agent integration",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 21
          }
        })),
        blogPostLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://ela.st/elastic-agent-ga-announcement",
          external: true,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.homeIntegration.tutorialModule.noticeText.blogPostLink",
          defaultMessage: "announcement blog post",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    }))));
  }
  return null;
});

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = exports.default = TutorialModuleNotice;
module.exports = exports.default;