"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmForceInstallModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/confirm_force_install_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmForceInstallModal = ({
  onCancel,
  onConfirm,
  pkg,
  docLinks
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const title = pkg && pkg.name && pkg.version ? _i18n.i18n.translate('xpack.fleet.ConfirmForceInstallModal.calloutTitleWithPkg', {
    defaultMessage: 'Integration {pkgName}-{pkgVersion} has failed verification',
    values: {
      pkgName: pkg.name,
      pkgVersion: pkg.version
    }
  }) : _i18n.i18n.translate('xpack.fleet.ConfirmForceInstallModal.calloutTitleNoPkg', {
    defaultMessage: 'The integration has failed verification'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmForceInstallModal.title",
      defaultMessage: "Install unverified integration?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    })),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmForceInstallModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmForceInstallModal.confirmButtonLabel",
      defaultMessage: "Install anyway",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }),
    buttonColor: "danger",
    "data-test-subj": "confirmForceInstallModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "warning",
    iconType: "warning",
    children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmForceInstallModal.calloutBody",
      defaultMessage: "This integration contains an unsigned package of unknown authenticity and could contain malicious files. Learn more about {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.packageSignatures,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.ConfirmForceInstallModal.learnMoreLink",
          defaultMessage: "package signatures",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
};
exports.ConfirmForceInstallModal = ConfirmForceInstallModal;