"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureStandaloneAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/configure_standalone_agent_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigureStandaloneAgentStep = ({
  isK8s,
  yaml,
  downloadYaml,
  apiKey,
  onCreateApiKey,
  isCreatingApiKey,
  isComplete,
  onCopy
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const policyMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescriptionk8s",
    defaultMessage: "Copy or download the Kubernetes manifest inside the Kubernetes cluster. Update {ESUsernameVariable} and {ESPasswordVariable} environment variables in the Daemonset to match your Elasticsearch credentials. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingGuideLink} before deploying this manifest.",
    values: {
      ESUsernameVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 31
        }
      }, "ES_USERNAME"),
      ESPasswordVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 31
        }
      }, "ES_PASSWORD"),
      scalingGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.scalingKubernetesResourcesAndLimits,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.k8ScalingGuideLinkText",
        defaultMessage: "Scaling Elastic Agent on Kubernetes",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescription",
    defaultMessage: "Copy this policy to the {fileName} on the host where the Elastic Agent is installed. Either use an existing API key and modify {apiKeyVariable} in the {outputSection} section of {fileName} or click the button below to generate a new one. Refer to {guideLink} for details.",
    values: {
      fileName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 21
        }
      }, "elastic-agent.yml"),
      apiKeyVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 27
        }
      }, "API_KEY"),
      outputSection: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 26
        }
      }, "outputs"),
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.grantESAccessToStandaloneAgents,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.standaloneAgentAccessLinkText",
        defaultMessage: "Grant standalone Elastic Agents access to Elasticsearch",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  });
  const downloadMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButtonk8s",
    defaultMessage: "Download manifest",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButton",
    defaultMessage: "Download policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  });
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfigureAgentTitle', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !yaml ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policyMsg), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    }), apiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.created', {
        defaultMessage: 'API key created.'
      }),
      color: "success",
      iconType: "check",
      "data-test-subj": "obltOnboardingLogsApiKeyCreated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.created.description', {
      defaultMessage: `Remember to store this information in a safe place. It won't be displayed anymore after you continue.`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "apmAgentKeyCallOutFieldText",
      readOnly: true,
      value: apiKey,
      "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.field.label', {
        defaultMessage: 'API key'
      }),
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: apiKey,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 21
        }
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "copyClipboard",
        onClick: copy,
        color: "success",
        css: {
          '> svg.euiIcon': {
            borderRadius: '0 !important'
          }
        },
        "aria-label": _i18n.i18n.translate('xpack.fleet.apiKeyBanner.field.copyButton', {
          defaultMessage: 'Copy to clipboard'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 25
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onCreateApiKey,
      isLoading: isCreatingApiKey,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.createApiKeyButton",
      defaultMessage: "Create API key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: yaml,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 17
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        copy();
        if (onCopy) onCopy();
      },
      iconType: "copyClipboard",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.copyPolicyButton",
      defaultMessage: "Copy to clipboard",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "download",
      onClick: () => {
        if (onCopy) onCopy();
        downloadYaml();
      },
      isDisabled: !downloadYaml,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, downloadMsg)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "yaml",
      style: {
        maxHeight: 300
      },
      fontSize: "m",
      "data-test-subj": "agentPolicyCodeBlock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 13
      }
    }, yaml))),
    status: !yaml ? 'loading' : isComplete ? 'complete' : undefined
  };
};
exports.ConfigureStandaloneAgentStep = ConfigureStandaloneAgentStep;