"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentEnrollmentKeySelectionStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _advanced_agent_authentication_settings = require("../advanced_agent_authentication_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/agent_enrollment_key_selection_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentEnrollmentKeySelectionStep = ({
  selectedPolicy,
  selectedApiKeyId,
  setSelectedAPIKeyId
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfigurePolicyAuthenticationTitle', {
      defaultMessage: 'Select enrollment token'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.agentAuthenticationSettings",
      defaultMessage: "{agentPolicyName} has been selected. Select which enrollment token to use when enrolling agents.",
      values: {
        agentPolicyName: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 32
          }
        }, selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.name)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_advanced_agent_authentication_settings.AdvancedAgentAuthenticationSettings, {
      agentPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
      selectedApiKeyId: selectedApiKeyId,
      initialAuthenticationSettingsOpen: true,
      onKeyChange: setSelectedAPIKeyId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }))
  };
};
exports.AgentEnrollmentKeySelectionStep = AgentEnrollmentKeySelectionStep;