"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _components = require("../../../../../../components");
var _hooks = require("../../../../../../hooks");
var _installed_integrations_table = require("./components/installed_integrations_table");
var _use_installed_integrations = require("./hooks/use_installed_integrations");
var _use_url_filters = require("./hooks/use_url_filters");
var _installed_integrations_search_bar = require("./components/installed_integrations_search_bar");
var _use_installed_integrations_actions = require("./hooks/use_installed_integrations_actions");
var _use_bulk_actions_context = require("./hooks/use_bulk_actions_context");
var _package_policies_panel = require("./components/package_policies_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InstalledIntegrationsPageContent = ({
  prereleaseIntegrationsEnabled
}) => {
  // State management
  const filters = (0, _use_url_filters.useUrlFilters)();
  const {
    selectedPackageViewPolicies
  } = (0, _use_url_filters.useViewPolicies)();
  const pagination = (0, _hooks.useUrlPagination)();
  const {
    upgradingIntegrations,
    uninstallingIntegrations,
    rollingbackIntegrations
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  const {
    installedPackages,
    countPerStatus,
    customIntegrationsCount,
    isLoading,
    isInitialLoading,
    total
  } = (0, _use_installed_integrations.useInstalledIntegrations)(filters, pagination.pagination, upgradingIntegrations, uninstallingIntegrations, rollingbackIntegrations, prereleaseIntegrationsEnabled);
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const viewPoliciesSelectedItem = (0, _react.useMemo)(() => selectedPackageViewPolicies ? installedPackages.find(item => item.name === selectedPackageViewPolicies) : null, [selectedPackageViewPolicies, installedPackages]);
  if (isInitialLoading) {
    return /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin: auto;
          height: 100%;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_installed_integrations_search_bar.InstalledIntegrationsSearchBar, {
    filters: filters,
    customIntegrationsCount: customIntegrationsCount,
    countPerStatus: countPerStatus,
    selectedItems: selectedItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_installed_integrations_table.InstalledIntegrationsTable, {
    total: total,
    pagination: pagination,
    isLoading: isInitialLoading || isLoading,
    installedPackages: installedPackages,
    selection: {
      selectedItems,
      setSelectedItems
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })), viewPoliciesSelectedItem ? /*#__PURE__*/_react.default.createElement(_package_policies_panel.PackagePoliciesPanel, {
    installedPackage: viewPoliciesSelectedItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }) : null);
};
const InstalledIntegrationsPage = ({
  prereleaseIntegrationsEnabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_bulk_actions_context.BulkActionContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(InstalledIntegrationsPageContent, {
    prereleaseIntegrationsEnabled: prereleaseIntegrationsEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.InstalledIntegrationsPage = InstalledIntegrationsPage;