"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationPreference = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/integration_preference.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const recommendedTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.integrationPreference.recommendedTooltip",
  defaultMessage: "We recommend Elastic Agent integrations when they are generally available.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
});
const Item = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-left: ${props => props.theme.eui.euiSizeXS};
`;
const EuiSwitchNoWrap = (0, _styledComponents.default)(_eui.EuiSwitch)`
  white-space: nowrap;
`;
const options = [{
  type: 'recommended',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.recommendedLabel', {
    defaultMessage: 'Recommended'
  })), /*#__PURE__*/_react.default.createElement(Item, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: recommendedTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })))
}, {
  type: 'agent',
  label: _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.elasticAgentLabel', {
    defaultMessage: 'Elastic Agent only'
  })
}, {
  type: 'beats',
  label: _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.beatsLabel', {
    defaultMessage: 'Beats only'
  })
}];
const IntegrationPreference = ({
  initialType,
  onChange,
  prereleaseIntegrationsEnabled
}) => {
  const [idSelected, setIdSelected] = _react.default.useState(initialType);
  const [prereleaseIntegrationsChecked, setPrereleaseIntegrationsChecked] = _react.default.useState(undefined);
  const authz = (0, _hooks.useAuthz)();
  const {
    docLinks,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    mutateAsync: mutateSettingsAsync
  } = (0, _hooks.usePutSettingsMutation)();
  const updateSettings = (0, _react.useCallback)(async prerelease => {
    try {
      setPrereleaseIntegrationsChecked(prerelease);
      const res = await mutateSettingsAsync({
        prerelease_integrations_enabled: prerelease
      });
      if (res.error) {
        throw res.error;
      }
    } catch (error) {
      setPrereleaseIntegrationsChecked(!prerelease);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.errorUpdatingSettings', {
          defaultMessage: 'Error updating settings'
        })
      });
    }
  }, [mutateSettingsAsync, notifications.toasts]);
  const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.beatsAgentComparison,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.integrationPreference.titleLink",
    defaultMessage: "Elastic Agent and Beats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.integrationPreference.title",
    defaultMessage: "If an integration is available for {link}, show:",
    values: {
      link
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  });
  const radios = options.map(option => ({
    id: option.type,
    value: option.type,
    label: option.label
  }));
  const onPrereleaseSwitchChange = event => {
    updateSettings(event.target.checked);
  };
  const canUpdateBetaSetting = authz.fleet.allSettings;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, canUpdateBetaSetting && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiSwitchNoWrap, {
    label: "Display beta integrations",
    checked: typeof prereleaseIntegrationsChecked !== 'undefined' ? prereleaseIntegrationsChecked : prereleaseIntegrationsEnabled,
    onChange: onPrereleaseSwitchChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 23
        }
      }, title)
    },
    options: radios,
    idSelected: idSelected,
    onChange: (id, value) => {
      setIdSelected(id);
      onChange(value);
    },
    name: "preference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }));
};
exports.IntegrationPreference = IntegrationPreference;