"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/spaces-plugin/common");
var _reactRouterDom = require("react-router-dom");
var _ensure_kibana_assets_installed = require("../../../../../services/ensure_kibana_assets_installed");
var _use_space_settings_context = require("../../../../../../../hooks/use_space_settings_context");
var _hooks = require("../../../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _services = require("../../../services");
var _constants = require("../../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const pickAgentPolicyKeysToSend = agentPolicy => {
  var _agentPolicy$space_id;
  const partialPolicy = (0, _lodash.pick)(agentPolicy, ['name', 'description', 'namespace', 'monitoring_enabled', 'unenroll_timeout', 'inactivity_timeout', 'data_output_id', 'monitoring_output_id', 'download_source_id', 'fleet_server_host_id', 'agent_features', 'is_protected', 'advanced_settings', 'global_data_tags', 'monitoring_pprof_enabled', 'monitoring_http', 'monitoring_diagnostics']);
  return {
    ...partialPolicy,
    ...(!((_agentPolicy$space_id = agentPolicy.space_ids) !== null && _agentPolicy$space_id !== void 0 && _agentPolicy$space_id.includes(_constants.UNKNOWN_SPACE)) && {
      space_ids: agentPolicy.space_ids
    })
  };
};
const FormWrapper = _styledComponents.default.div`
  max-width: 1200px;
  margin-right: auto;
  margin-left: auto;
`;
const SettingsView = exports.SettingsView = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy: originalAgentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('policy_details', {
    policyName: originalAgentPolicy.name
  });
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const hasAllAgentPoliciesPrivileges = (0, _hooks.useAuthz)().fleet.allAgentPolicies;
  const refreshAgentPolicy = (0, _hooks.useAgentPolicyRefresh)();
  const [agentPolicy, setAgentPolicy] = (0, _react.useState)({
    ...originalAgentPolicy
  });
  const history = (0, _reactRouterDom.useHistory)();
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [hasChanges, setHasChanges] = (0, _react.useState)(false);
  const [agentCount, setAgentCount] = (0, _react.useState)(0);
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const validation = (0, _components.agentPolicyFormValidation)(agentPolicy, {
    allowedNamespacePrefixes: spaceSettings === null || spaceSettings === void 0 ? void 0 : spaceSettings.allowedNamespacePrefixes
  });
  const [hasAdvancedSettingsErrors, setHasAdvancedSettingsErrors] = (0, _react.useState)(false);
  const [hasInvalidSpaceError, setInvalidSpaceError] = (0, _react.useState)(false);
  const updateAgentPolicy = updatedFields => {
    setAgentPolicy({
      ...agentPolicy,
      ...updatedFields
    });
    setHasChanges(true);
  };
  const submitUpdateAgentPolicy = async () => {
    setIsLoading(true);
    try {
      const dataToSend = pickAgentPolicyKeysToSend(agentPolicy);
      await (0, _hooks.sendUpdateAgentPolicyForRq)(agentPolicy.id, pickAgentPolicyKeysToSend(agentPolicy));
      if (dataToSend.space_ids && !(0, _fastDeepEqual.default)(originalAgentPolicy.space_ids, dataToSend.space_ids)) {
        var _originalAgentPolicy$, _originalAgentPolicy$2;
        const packages = (0, _lodash.uniqBy)((_originalAgentPolicy$ = (_originalAgentPolicy$2 = originalAgentPolicy.package_policies) === null || _originalAgentPolicy$2 === void 0 ? void 0 : _originalAgentPolicy$2.map(pp => pp.package ? {
          pkgName: pp.package.name,
          pkgVersion: pp.package.version
        } : undefined).filter(p => typeof p !== 'undefined')) !== null && _originalAgentPolicy$ !== void 0 ? _originalAgentPolicy$ : [], 'pkgName');
        for (const {
          pkgName,
          pkgVersion
        } of packages) {
          await (0, _ensure_kibana_assets_installed.ensurePackageKibanaAssetsInstalled)({
            spaceIds: dataToSend.space_ids,
            pkgName,
            pkgVersion,
            toasts: notifications.toasts
          });
        }
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.editAgentPolicy.successNotificationTitle', {
        defaultMessage: "Successfully updated ''{name}'' settings",
        values: {
          name: agentPolicy.name
        }
      }));
      if (agentPolicy.space_ids && !agentPolicy.space_ids.includes(spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID)) {
        history.replace(getPath('policies_list'));
      } else {
        refreshAgentPolicy();
        setHasChanges(false);
      }
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.editAgentPolicy.errorNotificationTitle', {
          defaultMessage: 'Unable to update agent policy'
        })
      });
    }
    setIsLoading(false);
  };
  const devtoolRequest = (0, _react.useMemo)(() => (0, _services.generateUpdateAgentPolicyDevToolsRequest)(agentPolicy.id, pickAgentPolicyKeysToSend(agentPolicy)), [agentPolicy]);
  const onSubmit = async () => {
    // Retrieve agent count if fleet is enabled
    if (isFleetEnabled) {
      setIsLoading(true);
      const {
        data
      } = await (0, _hooks.sendGetAgentStatus)({
        policyId: agentPolicy.id
      });
      if (data !== null && data !== void 0 && data.results.active) {
        setAgentCount(data.results.active);
      } else {
        await submitUpdateAgentPolicy();
      }
    } else {
      await submitUpdateAgentPolicy();
    }
  };
  return /*#__PURE__*/_react.default.createElement(FormWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, agentCount ? /*#__PURE__*/_react.default.createElement(_components.ConfirmDeployAgentPolicyModal, {
    agentCount: agentCount,
    agentPolicies: [agentPolicy],
    onConfirm: () => {
      setAgentCount(0);
      submitUpdateAgentPolicy();
    },
    onCancel: () => {
      setAgentCount(0);
      setIsLoading(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_components.AgentPolicyForm, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: newValue => setWithSysMonitoring(newValue),
    validation: validation,
    isEditing: true,
    updateAdvancedSettingsHasErrors: setHasAdvancedSettingsErrors,
    setInvalidSpaceError: setInvalidSpaceError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }), hasChanges ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editAgentPolicy.unsavedChangesText",
    defaultMessage: "You have unsaved changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: () => {
      setAgentPolicy({
        ...originalAgentPolicy
      });
      setHasChanges(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editAgentPolicy.cancelButtonText",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.DevtoolsRequestFlyoutButton, {
    isDisabled: isLoading || Object.keys(validation).length > 0 || hasAdvancedSettingsErrors || hasInvalidSpaceError,
    btnProps: {
      color: 'text'
    },
    description: _i18n.i18n.translate('xpack.fleet.editAgentPolicy.devtoolsRequestDescription', {
      defaultMessage: 'This Kibana request updates an agent policy.'
    }),
    request: devtoolRequest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSubmit,
    isLoading: isLoading,
    isDisabled: !hasAllAgentPoliciesPrivileges || isLoading || Object.keys(validation).length > 0 || hasAdvancedSettingsErrors || hasInvalidSpaceError,
    "data-test-subj": "agentPolicyDetailsSaveButton",
    iconType: "save",
    color: "primary",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 23
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editAgentPolicy.savingButtonText",
    defaultMessage: "Saving\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 27
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editAgentPolicy.saveButtonText",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 27
    }
  })))))))) : null);
});