"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepSelectAgentPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../../components");
var _services = require("../../../../../services");
var _hooks = require("../../../../../hooks");
var _agent_policy_multi_select = require("./components/agent_policy_multi_select");
var _agent_policy_options = require("./components/agent_policy_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/step_select_agent_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    width: 100%;
  }
`;
function doesAgentPolicyHaveLimitedPackage(policy, pkgInfo) {
  return policy ? (0, _services.isPackageLimited)(pkgInfo) && (0, _services.doesAgentPolicyAlreadyIncludePackage)(policy, pkgInfo.name) : false;
}
const StepSelectAgentPolicy = ({
  packageInfo,
  agentPolicies,
  updateAgentPolicies: updateSelectedAgentPolicies,
  setHasAgentPolicyError,
  initialSelectedAgentPolicyIds
}) => {
  const {
    isReady: isFleetReady
  } = (0, _hooks.useFleetStatus)();
  const [selectedAgentPolicyError, setSelectedAgentPolicyError] = (0, _react.useState)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const {
    isLoading,
    agentPoliciesError,
    agentPolicyOptions,
    agentPolicyMultiOptions,
    agentPolicies: existingAgentPolicies
  } = (0, _agent_policy_options.useAgentPoliciesOptions)(packageInfo);
  const [selectedPolicyIds, setSelectedPolicyIds] = (0, _react.useState)([]);
  const [isFirstLoad, setIsFirstLoad] = (0, _react.useState)(true);
  const [isLoadingSelectedAgentPolicies, setIsLoadingSelectedAgentPolicies] = (0, _react.useState)(false);
  const [selectedAgentPolicies, setSelectedAgentPolicies] = (0, _react.useState)(agentPolicies);
  const updateAgentPolicies = (0, _react.useCallback)(selectedPolicies => {
    setSelectedAgentPolicies(selectedPolicies);
    updateSelectedAgentPolicies(selectedPolicies);
  }, [updateSelectedAgentPolicies]);
  // Update parent selected agent policy state
  (0, _react.useEffect)(() => {
    const fetchAgentPolicyInfo = async () => {
      if (selectedPolicyIds.length > 0) {
        setIsLoadingSelectedAgentPolicies(true);
        const {
          data,
          error
        } = await (0, _hooks.sendBulkGetAgentPolicies)(selectedPolicyIds, {
          full: true
        });
        if (error) {
          setSelectedAgentPolicyError(error);
          updateAgentPolicies([]);
        } else if (data && data.items) {
          setSelectedAgentPolicyError(undefined);
          updateAgentPolicies(data.items);
        }
        setIsLoadingSelectedAgentPolicies(false);
      } else {
        setSelectedAgentPolicyError(undefined);
        updateAgentPolicies([]);
      }
    };
    if (isLoading || isFirstLoad) {
      return;
    }
    const agentPolicyIds = agentPolicies.map(policy => policy.id);
    const agentPoliciesHaveAllSelectedIds = selectedPolicyIds.every(id => agentPolicyIds.includes(id));
    if (agentPolicies.length === 0 && selectedPolicyIds.length !== 0 || !agentPoliciesHaveAllSelectedIds) {
      fetchAgentPolicyInfo();
    } else if (agentPoliciesHaveAllSelectedIds && selectedPolicyIds.length < agentPolicies.length) {
      setSelectedAgentPolicyError(undefined);
      updateAgentPolicies(agentPolicies.filter(policy => selectedPolicyIds.includes(policy.id)));
    }
  }, [selectedPolicyIds, agentPolicies, updateAgentPolicies, isLoading, isFirstLoad]);

  // Try to select default agent policy
  (0, _react.useEffect)(() => {
    if (isFirstLoad && selectedPolicyIds.length === 0 && existingAgentPolicies.length && (canUseMultipleAgentPolicies ? agentPolicyMultiOptions.length : agentPolicyOptions.length)) {
      setIsFirstLoad(false);
      if (canUseMultipleAgentPolicies) {
        const enabledOptions = agentPolicyMultiOptions.filter(option => !option.disabled);
        if (enabledOptions.length === 1 && initialSelectedAgentPolicyIds.length === 0) {
          setSelectedPolicyIds([enabledOptions[0].key]);
        } else if (initialSelectedAgentPolicyIds.length > 0) {
          setSelectedPolicyIds(initialSelectedAgentPolicyIds);
        }
      } else {
        const enabledOptions = agentPolicyOptions.filter(option => !option.disabled);
        if (enabledOptions.length === 1) {
          setSelectedPolicyIds([enabledOptions[0].value]);
        } else if (initialSelectedAgentPolicyIds.length > 0) {
          setSelectedPolicyIds(initialSelectedAgentPolicyIds);
        }
      }
    }
  }, [agentPolicyOptions, agentPolicyMultiOptions, canUseMultipleAgentPolicies, initialSelectedAgentPolicyIds, selectedPolicyIds, existingAgentPolicies, isFirstLoad]);

  // Bubble up any issues with agent policy selection
  (0, _react.useEffect)(() => {
    if (!selectedAgentPolicyError) {
      setHasAgentPolicyError(false);
    } else {
      setHasAgentPolicyError(true);
    }
  }, [selectedAgentPolicyError, selectedPolicyIds, setHasAgentPolicyError]);
  const onChange = (0, _react.useCallback)(newValue => setSelectedPolicyIds(newValue === '' ? [] : [newValue]), []);

  // Display agent policies list error if there is one
  if (agentPoliciesError) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingAgentPoliciesTitle",
        defaultMessage: "Error loading agent policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      }),
      error: agentPoliciesError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 7
      }
    });
  }
  const someNewAgentPoliciesHaveLimitedPackage = !packageInfo || selectedAgentPolicies.filter(policy => !initialSelectedAgentPolicyIds.find(id => policy.id === id)).some(selectedAgentPolicy => doesAgentPolicyHaveLimitedPackage(selectedAgentPolicy, packageInfo));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyFormGroupTitle",
      defaultMessage: "Agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 19
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyFormGroupDescription",
      defaultMessage: "Agent policies are used to manage a group of integrations across a set of agents.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 19
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(AgentPolicyFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyLabel",
      defaultMessage: "Agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 21
      }
    }))),
    helpText: isFleetReady && selectedPolicyIds.length > 0 && !isLoadingSelectedAgentPolicies ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyAgentsDescriptionText",
      defaultMessage: "{count, plural, one {# agent is} other {# agents are}} enrolled with the selected agent policies.",
      values: {
        count: selectedAgentPolicies.reduce((acc, curr) => {
          var _curr$agents;
          return acc + ((_curr$agents = curr.agents) !== null && _curr$agents !== void 0 ? _curr$agents : 0);
        }, 0)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 19
      }
    }) : null,
    isInvalid: Boolean(someNewAgentPoliciesHaveLimitedPackage),
    error: someNewAgentPoliciesHaveLimitedPackage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.cannotAddLimitedIntegrationError",
      defaultMessage: "This integration can only be added once per agent policy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 19
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }, canUseMultipleAgentPolicies ? /*#__PURE__*/_react.default.createElement(_agent_policy_multi_select.AgentPolicyMultiSelect, {
    isLoading: isLoading || !packageInfo || isLoadingSelectedAgentPolicies,
    selectedPolicyIds: selectedPolicyIds,
    setSelectedPolicyIds: setSelectedPolicyIds,
    agentPolicyMultiOptions: agentPolicyMultiOptions,
    selectedAgentPolicies: agentPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    placeholder: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyPlaceholderText', {
      defaultMessage: 'Select an agent policy to add this integration to'
    }),
    fullWidth: true,
    isLoading: isLoading || !packageInfo || isLoadingSelectedAgentPolicies,
    options: agentPolicyOptions,
    valueOfSelected: selectedPolicyIds[0],
    onChange: onChange,
    "data-test-subj": "agentPolicySelect",
    "aria-label": "Select Agent Policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  })))), selectedAgentPolicyError ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingSelectedAgentPolicyTitle",
      defaultMessage: "Error loading selected agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 17
      }
    }),
    error: selectedAgentPolicyError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 13
    }
  })) : null));
};
exports.StepSelectAgentPolicy = StepSelectAgentPolicy;