"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyCopyProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_copy_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyCopyProvider = ({
  children
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [agentPolicy, setAgentPolicy] = (0, _react.useState)();
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const copyAgentPolicyPrompt = (agentPolicyToCopy, onSuccess = () => undefined) => {
    if (!agentPolicyToCopy) {
      throw new Error('No agent policy specified to duplicate');
    }
    setIsModalOpen(true);
    setAgentPolicy(agentPolicyToCopy);
    setNewAgentPolicy({
      name: _i18n.i18n.translate('xpack.fleet.copyAgentPolicy.confirmModal.defaultNewPolicyName', {
        defaultMessage: '{name} (copy)',
        values: {
          name: agentPolicyToCopy.name
        }
      }),
      description: agentPolicyToCopy.description
    });
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setAgentPolicy(undefined);
    setNewAgentPolicy(undefined);
    setIsLoading(false);
    setIsModalOpen(false);
  };
  const copyAgentPolicy = async () => {
    setIsLoading(true);
    try {
      const {
        data,
        error
      } = await (0, _hooks.sendCopyAgentPolicy)(agentPolicy.id, newAgentPolicy);
      if (error) {
        throw error;
      }
      if (!data) {
        throw new Error('Error duplicating agent policy: no data');
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.copyAgentPolicy.successNotificationTitle', {
        defaultMessage: 'Agent policy duplicated'
      }));
      closeModal();
      if (onSuccessCallback.current) {
        onSuccessCallback.current(data.item);
      }
    } catch (e) {
      setIsLoading(false);
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.copyAgentPolicy.fatalErrorNotificationTitle', {
          defaultMessage: 'Error duplicating agent policy'
        })
      });
    }
  };
  const renderModal = () => {
    if (!isModalOpen || !agentPolicy || !newAgentPolicy) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      titleProps: {
        id: modalTitleId
      },
      title: /*#__PURE__*/_react.default.createElement("span", {
        className: "eui-textBreakWord",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.copyAgentPolicy.confirmModal.copyPolicyTitle",
        defaultMessage: "Duplicate ''{name}'' agent policy",
        values: {
          name: agentPolicy.name
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      })),
      onCancel: closeModal,
      onConfirm: copyAgentPolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.copyAgentPolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.copyAgentPolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Duplicate policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 11
        }
      }),
      confirmButtonDisabled: isLoading || !newAgentPolicy.name.trim(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.copyAgentPolicy.confirmModal.copyPolicyPrompt",
      defaultMessage: "Choose a name and description for your new agent policy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.copyAgentPolicy.confirmModal.newNameLabel",
        defaultMessage: "New policy name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 13
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: newAgentPolicy.name,
      onChange: e => setNewAgentPolicy({
        ...newAgentPolicy,
        name: e.target.value
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.copyAgentPolicy.confirmModal.newDescriptionLabel",
        defaultMessage: "Description",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 13
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: newAgentPolicy.description,
      onChange: e => setNewAgentPolicy({
        ...newAgentPolicy,
        description: e.target.value
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, children(copyAgentPolicyPrompt), renderModal());
};
exports.AgentPolicyCopyProvider = AgentPolicyCopyProvider;