"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGettingStartedStep = getGettingStartedStep;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _multi_row_input = require("../../../sections/settings/components/multi_row_input");
var _hooks = require("../../../hooks");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/get_started.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getGettingStartedStep(props) {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.getStartedTitle', {
      defaultMessage: 'Get started with Fleet Server'
    }),
    status: props.status === 'success' ? 'complete' : 'current',
    children: /*#__PURE__*/_react.default.createElement(GettingStartedStepContent, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 15
      }
    }))
  };
}
const GettingStartedStepContent = ({
  fleetServerHosts,
  fleetServerHost: selectedFleetServerHost,
  setFleetServerHost,
  status,
  error,
  inputs,
  submit,
  onClose
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const canWritePolicies = authz.fleet.allAgentPolicies && authz.integrations.writeIntegrationPolicies;
  const isDisabled = fleetServerHosts.length === 0 && !canWritePolicies;
  if (status === 'success') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "success",
      iconType: "check",
      title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.generateFleetServerPolicySuccessTitle', {
        defaultMessage: 'Fleet Server policy created.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerFlyout.generateFleetServerPolicySuccessInstructions",
      defaultMessage: "Fleet server policy and service token have been generated. Host configured at {hostUrl}. You can edit your Fleet Server hosts in {fleetSettingsLink}.",
      values: {
        hostUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 24
          }
        }, selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.host_urls[0]),
        fleetSettingsLink:
        /*#__PURE__*/
        // eslint-disable-next-line @elastic/eui/href-or-on-click
        _react.default.createElement(_eui.EuiLink, {
          href: getHref('settings'),
          onClick: onClose,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.fleetSettingsLink",
          defaultMessage: "Fleet Settings",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.getStartedInstructions",
    defaultMessage: "First, set the public IP or host name and port that agents will use to reach Fleet Server. It uses port {port} by default {toolTip}. We'll then generate a policy for you automatically.",
    values: {
      port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 19
        }
      }, "8220"),
      toolTip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          className: 'eui-alignTop'
        },
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.getStartedInstructionsPortTooltips",
          defaultMessage: "This can only be set during Fleet Server installation.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 19
          }
        }),
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_components.FleetServerHostSelect, {
    setFleetServerHost: setFleetServerHost,
    selectedFleetServerHost: selectedFleetServerHost,
    fleetServerHosts: fleetServerHosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: submit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, !selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.nameInputLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 17
      }
    })
  }, inputs.nameInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.nameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }, inputs.nameInput.props, {
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.hostUrlLabel",
      defaultMessage: "URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.multiRowInput"
  }, inputs.hostUrlsInput.props, {
    disabled: isDisabled,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  })), status === 'error' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 40
    }
  }, error))), fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    disabled: false,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 17
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: status === 'loading',
    onClick: submit,
    "data-test-subj": "generateFleetServerPolicyButton",
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.continueFleetServerPolicyButton",
    defaultMessage: "Continue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.generateFleetServerPolicyButton",
    defaultMessage: "Generate Fleet Server policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }))));
};