"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricFormatter = exports.getColor = void 0;
var _coloring = require("@kbn/coloring");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _services = require("../services");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function enhanceFieldFormat(serializedFieldFormat, formatOverrides) {
  var _serializedFieldForma;
  const formatId = (serializedFieldFormat === null || serializedFieldFormat === void 0 ? void 0 : serializedFieldFormat.id) || 'number';
  if (formatId === 'duration' && !(serializedFieldFormat !== null && serializedFieldFormat !== void 0 && (_serializedFieldForma = serializedFieldFormat.params) !== null && _serializedFieldForma !== void 0 && _serializedFieldForma.formatOverride)) {
    return {
      ...serializedFieldFormat,
      params: {
        // by default use the compact precise format
        outputFormat: 'humanizePrecise',
        outputPrecision: 1,
        useShortSuffix: true,
        // but if user configured something else, use it
        ...serializedFieldFormat.params
      }
    };
  }
  if (formatOverrides && formatId in formatOverrides) {
    return {
      ...serializedFieldFormat,
      params: {
        ...(serializedFieldFormat === null || serializedFieldFormat === void 0 ? void 0 : serializedFieldFormat.params),
        ...formatOverrides[formatId]
      }
    };
  }
  return serializedFieldFormat !== null && serializedFieldFormat !== void 0 ? serializedFieldFormat : {
    id: formatId
  };
}
const getMetricFormatter = (accessor, columns, formatOverrides) => {
  var _getColumnByAccessor;
  const type = (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(accessor, columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.meta.type;
  const defaultFormat = type ? {
    id: type
  } : undefined;
  const serializedFieldFormat = (0, _utils.getFormatByAccessor)(accessor, columns, defaultFormat);
  const enhancedFieldFormat = enhanceFieldFormat(serializedFieldFormat, formatOverrides);
  return (0, _services.getFormatService)().deserialize(enhancedFieldFormat).getConverterFor('text');
};
exports.getMetricFormatter = getMetricFormatter;
const getColor = (value, palette, accessors, data, rowNumber) => {
  var _getPaletteService$ge, _getPaletteService$ge2;
  const {
    min,
    max
  } = (0, _utils2.getDataBoundsForPalette)(accessors, data, rowNumber);
  return (_getPaletteService$ge = (0, _services.getPaletteService)().get(_coloring.CUSTOM_PALETTE)) === null || _getPaletteService$ge === void 0 ? void 0 : (_getPaletteService$ge2 = _getPaletteService$ge.getColorForValue) === null || _getPaletteService$ge2 === void 0 ? void 0 : _getPaletteService$ge2.call(_getPaletteService$ge, value, palette.params, {
    min,
    max
  });
};
exports.getColor = getColor;