"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewActions = ViewActions;
exports.removeUndefinedEmptyValues = removeUndefinedEmptyValues;
exports.removeUndefinedProps = removeUndefinedProps;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_series_storage = require("../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/views/view_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function removeUndefinedEmptyValues(series) {
  const resultSeries = removeUndefinedProps(series);
  Object.entries(resultSeries).forEach(([prop, value]) => {
    if (typeof value === 'object') {
      // @ts-expect-error
      resultSeries[prop] = removeUndefinedEmptyValues(value);
    }
  });
  return resultSeries;
}
function removeUndefinedProps(obj) {
  return (0, _lodash.pickBy)(obj, value => value !== undefined);
}
function ViewActions({
  onApply
}) {
  var _storage$get, _storage$get2;
  const {
    allSeries,
    storage,
    applyChanges,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const urlAllSeries = (0, _use_series_storage.convertAllShortSeries)((_storage$get = storage.get(_use_series_storage.allSeriesKey)) !== null && _storage$get !== void 0 ? _storage$get : []);
  const urlReportType = (_storage$get2 = storage.get(_use_series_storage.reportTypeKey)) !== null && _storage$get2 !== void 0 ? _storage$get2 : '';
  let noChanges = allSeries.length === urlAllSeries.length && reportType === urlReportType;
  if (noChanges) {
    noChanges = !allSeries.some((series, index) => !(0, _lodash.isEqual)(removeUndefinedEmptyValues(series), removeUndefinedEmptyValues(urlAllSeries[index])));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => applyChanges(onApply),
    isDisabled: noChanges,
    fill: true,
    "data-test-subj": 'seriesChangesApplyButton',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.apply', {
    defaultMessage: 'Apply changes'
  }))));
}