"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityExploratoryView = ObservabilityExploratoryView;
exports.reportTypesList = exports.obsvReportConfigMap = exports.dataTypes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _single_metric_config = require("./configurations/alerts_configs/single_metric_config");
var _kpi_over_time_config = require("./configurations/alerts_configs/kpi_over_time_config");
var _labels = require("./labels");
var _heatmap_config = require("./configurations/synthetics/heatmap_config");
var _single_metric_config2 = require("./configurations/synthetics/single_metric_config");
var _ = require(".");
var _exploratory_view_config = require("./contexts/exploratory_view_config");
var _labels2 = require("./configurations/constants/labels");
var _data_distribution_config = require("./configurations/rum/data_distribution_config");
var _kpi_over_time_config2 = require("./configurations/rum/kpi_over_time_config");
var _core_web_vitals_config = require("./configurations/rum/core_web_vitals_config");
var _kpi_over_time_config3 = require("./configurations/synthetics/kpi_over_time_config");
var _data_distribution_config2 = require("./configurations/synthetics/data_distribution_config");
var _distribution_config = require("./configurations/mobile/distribution_config");
var _kpi_over_time_config4 = require("./configurations/mobile/kpi_over_time_config");
var _device_distribution_config = require("./configurations/mobile/device_distribution_config");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _kpi_over_time_config5 = require("./configurations/infra_logs/kpi_over_time_config");
var _single_metric_config3 = require("./configurations/rum/single_metric_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/obsv_exploratory_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dataTypes = exports.dataTypes = [{
  id: _labels.DataTypes.UPTIME,
  label: _labels.DataTypesLabels[_labels.DataTypes.UPTIME]
}, {
  id: _labels.DataTypes.SYNTHETICS,
  label: _labels.DataTypesLabels[_labels.DataTypes.SYNTHETICS]
}, {
  id: _labels.DataTypes.UPTIME,
  label: _labels.DataTypesLabels[_labels.DataTypes.UPTIME]
}, {
  id: _labels.DataTypes.UX,
  label: _labels.DataTypesLabels[_labels.DataTypes.UX]
}, {
  id: _labels.DataTypes.LOGS,
  label: _labels.DataTypesLabels[_labels.DataTypes.LOGS]
}, {
  id: _labels.DataTypes.MOBILE,
  label: _labels.DataTypesLabels[_labels.DataTypes.MOBILE]
}, {
  id: _labels.DataTypes.ALERTS,
  label: _labels.DataTypesLabels[_labels.DataTypes.ALERTS]
}];
const reportTypesList = exports.reportTypesList = [{
  reportType: 'kpi-over-time',
  label: _labels2.KPI_OVER_TIME_LABEL
}, {
  reportType: 'data-distribution',
  label: _labels2.PERF_DIST_LABEL
}, {
  reportType: 'core-web-vitals',
  label: _labels2.CORE_WEB_VITALS_LABEL
}, {
  reportType: 'device-data-distribution',
  label: _labels2.DEVICE_DISTRIBUTION_LABEL
}, {
  reportType: 'single-metric',
  label: _labels2.SINGLE_METRIC_LABEL
}, {
  reportType: 'heatmap',
  label: _labels2.HEATMAP_LABEL
}];
const obsvReportConfigMap = exports.obsvReportConfigMap = {
  [_labels.DataTypes.UX]: [_kpi_over_time_config2.getKPITrendsLensConfig, _data_distribution_config.getRumDistributionConfig, _core_web_vitals_config.getCoreWebVitalsConfig, _single_metric_config3.getSingleMetricConfig],
  [_labels.DataTypes.SYNTHETICS]: [_kpi_over_time_config3.getSyntheticsKPIConfig, _data_distribution_config2.getSyntheticsDistributionConfig, _single_metric_config2.getSyntheticsSingleMetricConfig, _heatmap_config.getSyntheticsHeatmapConfig],
  [_labels.DataTypes.UPTIME]: [_kpi_over_time_config3.getSyntheticsKPIConfig, _data_distribution_config2.getSyntheticsDistributionConfig, _single_metric_config2.getSyntheticsSingleMetricConfig, _heatmap_config.getSyntheticsHeatmapConfig],
  [_labels.DataTypes.MOBILE]: [_kpi_over_time_config4.getMobileKPIConfig, _distribution_config.getMobileKPIDistributionConfig, _device_distribution_config.getMobileDeviceDistributionConfig],
  [_labels.DataTypes.LOGS]: [_kpi_over_time_config5.getLogsKPIConfig],
  [_labels.DataTypes.ALERTS]: [_kpi_over_time_config.getAlertsKPIConfig, _single_metric_config.getAlertsSingleMetricConfig]
};
function ObservabilityExploratoryView(props) {
  const {
    appMountParameters
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/React.createElement(_exploratory_view_config.ExploratoryViewContextProvider, (0, _extends2.default)({
    reportTypes: reportTypesList,
    dataTypes: dataTypes,
    reportConfigMap: obsvReportConfigMap,
    setHeaderActionMenu: appMountParameters.setHeaderActionMenu,
    theme$: appMountParameters.theme$
  }, props.startServices, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }), /*#__PURE__*/React.createElement(_.ExploratoryViewPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
}