"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbedAction = EmbedAction;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_series_storage = require("../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/header/embed_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EmbedAction({
  lensAttributes
}) {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    reportType,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yEmbedActionButton",
    size: "s",
    isDisabled: lensAttributes === null,
    onClick: () => {
      setIsOpen(!isOpen);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, EMBED_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, EMBED_TITLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "jsx",
    fontSize: "m",
    paddingSize: "m",
    isCopyable: true,
    style: {
      width: 500
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, `const { observability } = useKibana<>().services;

const { ExploratoryViewEmbeddable } = observability;

<ExploratoryViewEmbeddable
        customHeight={'300px'}
        reportType="${reportType}"
        attributes={${JSON.stringify(allSeries, null, 2)}}
 />
        `));
}
const EMBED_TITLE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.embedTitle', {
  defaultMessage: 'Embed Exploratory view (Dev only feature)'
});
const EMBED_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.embed', {
  defaultMessage: 'Embed <></>',
  ignoreTag: true
});