"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGroupValid = exports.GroupEditorControls = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = _interopRequireWildcard(require("react"));
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _annotation_list = require("./annotation_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/event_annotation_listing/public/components/group_editor_flyout/group_editor_controls/group_editor_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isTitleValid = title => Boolean(title.length);
const isDataViewValid = dataView => Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.id);
const isGroupValid = (group, dataViews) => isTitleValid(group.title) && isDataViewValid(dataViews.find(({
  id
}) => id === group.indexPatternId));
exports.isGroupValid = isGroupValid;
const GroupEditorControls = ({
  group,
  update,
  setSelectedAnnotation: _setSelectedAnnotation,
  selectedAnnotation,
  TagSelector,
  dataViews,
  queryInputServices,
  showValidation,
  isAdHocDataView
}) => {
  const setSelectedAnnotation = (0, _react2.useCallback)(newSelection => {
    update({
      ...group,
      annotations: group.annotations.map(annotation => annotation.id === newSelection.id ? newSelection : annotation)
    });
    _setSelectedAnnotation(newSelection);
  }, [_setSelectedAnnotation, group, update]);
  const currentDataView = (0, _react2.useMemo)(() => dataViews.find(dataView => dataView.id === group.indexPatternId), [dataViews, group.indexPatternId]);
  return !selectedAnnotation ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react.css)`
          margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditor.details",
    defaultMessage: "Details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.title', {
      defaultMessage: 'Title'
    }),
    isInvalid: showValidation && !isTitleValid(group.title),
    error: _i18n.i18n.translate('eventAnnotationListing.groupEditor.titleRequired', {
      defaultMessage: 'A title is required.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    "data-test-subj": "annotationGroupTitle",
    value: group.title,
    isInvalid: showValidation && !isTitleValid(group.title),
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      title: value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotationListing.groupEditor.optional",
      defaultMessage: "Optional",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextArea, {
    compressed: true,
    "data-test-subj": "annotationGroupDescription",
    value: group.description,
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      description: value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(TagSelector, {
    initialSelection: group.tags,
    markOptional: true,
    compressed: true,
    onTagsSelected: tags => update({
      ...group,
      tags
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.dataView', {
      defaultMessage: 'Data view'
    }),
    isInvalid: !isDataViewValid(currentDataView),
    error: !isDataViewValid(currentDataView) ? _i18n.i18n.translate('eventAnnotationListing.groupEditor.dataViewMissingError', {
      defaultMessage: 'The previously selected data view no longer exists.'
    }) : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelect, {
    compressed: true,
    "data-test-subj": "annotationDataViewSelection",
    isInvalid: !isDataViewValid(currentDataView),
    options: dataViews.map(({
      id: value,
      title,
      name
    }) => ({
      value,
      text: name !== null && name !== void 0 ? name : title
    })),
    value: isDataViewValid(currentDataView) ? group.indexPatternId : undefined,
    hasNoInitialSelection: true,
    onChange: ({
      target: {
        value
      }
    }) => {
      const selectedDataView = dataViews.find(({
        id
      }) => id === value);
      if (!(selectedDataView !== null && selectedDataView !== void 0 && selectedDataView.id)) {
        return;
      }
      update({
        ...group,
        indexPatternId: value,
        dataViewSpec: isAdHocDataView(selectedDataView.id) ? selectedDataView.toSpec(false) : undefined
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          margin-top: ${_uiTheme.euiThemeVars.euiSize};
          padding-top: ${_uiTheme.euiThemeVars.euiSize};
          position: relative;

          &:before {
            content: '';
            position: absolute;
            top: 0;
            right: -${_uiTheme.euiThemeVars.euiSize};
            left: -${_uiTheme.euiThemeVars.euiSize};
            border-top: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react.css)`
            margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditor.annotations",
    defaultMessage: "Annotations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.annotationGroupLabel', {
      defaultMessage: 'Date histogram axis'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_annotation_list.AnnotationList, {
    annotations: group.annotations,
    selectAnnotation: currentDataView ? setSelectedAnnotation : () => {},
    update: newAnnotations => update({
      ...group,
      annotations: newAnnotations
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }))))) : currentDataView ? /*#__PURE__*/_react2.default.createElement(_eventAnnotationComponents.AnnotationEditorControls, {
    annotation: selectedAnnotation,
    onAnnotationChange: changes => setSelectedAnnotation({
      ...selectedAnnotation,
      ...changes
    }),
    dataView: currentDataView,
    getDefaultRangeEnd: rangeStart => rangeStart,
    queryInputServices: queryInputServices,
    appName: _eventAnnotationComponents.EVENT_ANNOTATION_APP_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }) : null;
};
exports.GroupEditorControls = GroupEditorControls;