"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../../complete_items");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _await$callbacks$getB, _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  if (/MV_EXPAND\s+\S+\s+$/i.test(innerText)) {
    return [_complete_items.pipeCompleteItem];
  }
  const columnSuggestions = (_await$callbacks$getB = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, 'any', undefined, {
    advanceCursor: true,
    openSuggestions: true
  }))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
  const fragment = (0, _helpers.findFinalWord)(innerText);
  columnSuggestions.forEach(suggestion => {
    suggestion.rangeToReplace = {
      start: innerText.length - fragment.length + 1,
      end: innerText.length
    };
  });
  return columnSuggestions;
}